package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImagePrunerBuilder extends ImagePrunerFluent<ImagePrunerBuilder> implements VisitableBuilder<ImagePruner,ImagePrunerBuilder>{
  public ImagePrunerBuilder() {
    this(false);
  }
  public ImagePrunerBuilder(Boolean validationEnabled) {
    this(new ImagePruner(), validationEnabled);
  }
  public ImagePrunerBuilder(ImagePrunerFluent<?> fluent) {
    this(fluent, false);
  }
  public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImagePruner(), validationEnabled);
  }
  public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,ImagePruner instance) {
    this(fluent, instance, false);
  }
  public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,ImagePruner instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImagePruner());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImagePrunerBuilder(ImagePruner instance) {
    this(instance,false);
  }
  public ImagePrunerBuilder(ImagePruner instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImagePruner());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImagePrunerFluent<?> fluent;
  Boolean validationEnabled;
  public ImagePruner build() {
    ImagePruner buildable = new ImagePruner(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}