package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImagePrunerStatusBuilder extends ImagePrunerStatusFluent<ImagePrunerStatusBuilder> implements VisitableBuilder<ImagePrunerStatus,ImagePrunerStatusBuilder>{
  public ImagePrunerStatusBuilder() {
    this(false);
  }
  public ImagePrunerStatusBuilder(Boolean validationEnabled) {
    this(new ImagePrunerStatus(), validationEnabled);
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImagePrunerStatus(), validationEnabled);
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,ImagePrunerStatus instance) {
    this(fluent, instance, false);
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,ImagePrunerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImagePrunerStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatus instance) {
    this(instance,false);
  }
  public ImagePrunerStatusBuilder(ImagePrunerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImagePrunerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImagePrunerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImagePrunerStatus build() {
    ImagePrunerStatus buildable = new ImagePrunerStatus(fluent.buildConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}