package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerListBuilder extends IngressControllerListFluent<IngressControllerListBuilder> implements VisitableBuilder<IngressControllerList,IngressControllerListBuilder>{
  public IngressControllerListBuilder() {
    this(false);
  }
  public IngressControllerListBuilder(Boolean validationEnabled) {
    this(new IngressControllerList(), validationEnabled);
  }
  public IngressControllerListBuilder(IngressControllerListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerList(), validationEnabled);
  }
  public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,IngressControllerList instance) {
    this(fluent, instance, false);
  }
  public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,IngressControllerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressControllerList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerListBuilder(IngressControllerList instance) {
    this(instance,false);
  }
  public IngressControllerListBuilder(IngressControllerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressControllerList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressControllerListFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerList build() {
    IngressControllerList buildable = new IngressControllerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}