package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeControllerManagerListBuilder extends KubeControllerManagerListFluent<KubeControllerManagerListBuilder> implements VisitableBuilder<KubeControllerManagerList,KubeControllerManagerListBuilder>{
  public KubeControllerManagerListBuilder() {
    this(false);
  }
  public KubeControllerManagerListBuilder(Boolean validationEnabled) {
    this(new KubeControllerManagerList(), validationEnabled);
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeControllerManagerList(), validationEnabled);
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,KubeControllerManagerList instance) {
    this(fluent, instance, false);
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,KubeControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeControllerManagerList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerList instance) {
    this(instance,false);
  }
  public KubeControllerManagerListBuilder(KubeControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeControllerManagerList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeControllerManagerListFluent<?> fluent;
  Boolean validationEnabled;
  public KubeControllerManagerList build() {
    KubeControllerManagerList buildable = new KubeControllerManagerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}