package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeStorageVersionMigratorSpecBuilder extends KubeStorageVersionMigratorSpecFluent<KubeStorageVersionMigratorSpecBuilder> implements VisitableBuilder<KubeStorageVersionMigratorSpec,KubeStorageVersionMigratorSpecBuilder>{
  public KubeStorageVersionMigratorSpecBuilder() {
    this(false);
  }
  public KubeStorageVersionMigratorSpecBuilder(Boolean validationEnabled) {
    this(new KubeStorageVersionMigratorSpec(), validationEnabled);
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeStorageVersionMigratorSpec(), validationEnabled);
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpecFluent<?> fluent,KubeStorageVersionMigratorSpec instance) {
    this(fluent, instance, false);
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpecFluent<?> fluent,KubeStorageVersionMigratorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeStorageVersionMigratorSpec());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpec instance) {
    this(instance,false);
  }
  public KubeStorageVersionMigratorSpecBuilder(KubeStorageVersionMigratorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeStorageVersionMigratorSpec());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeStorageVersionMigratorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubeStorageVersionMigratorSpec build() {
    KubeStorageVersionMigratorSpec buildable = new KubeStorageVersionMigratorSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}