package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkMigrationBuilder extends NetworkMigrationFluent<NetworkMigrationBuilder> implements VisitableBuilder<NetworkMigration,NetworkMigrationBuilder>{
  public NetworkMigrationBuilder() {
    this(false);
  }
  public NetworkMigrationBuilder(Boolean validationEnabled) {
    this(new NetworkMigration(), validationEnabled);
  }
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkMigration(), validationEnabled);
  }
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent,NetworkMigration instance) {
    this(fluent, instance, false);
  }
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent,NetworkMigration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkMigration());

    if (instance != null) {
      fluent.withFeatures(instance.getFeatures());
      fluent.withMtu(instance.getMtu());
      fluent.withNetworkType(instance.getNetworkType());
      fluent.withFeatures(instance.getFeatures());
      fluent.withMtu(instance.getMtu());
      fluent.withNetworkType(instance.getNetworkType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkMigrationBuilder(NetworkMigration instance) {
    this(instance,false);
  }
  public NetworkMigrationBuilder(NetworkMigration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkMigration());

    if (instance != null) {
      this.withFeatures(instance.getFeatures());
      this.withMtu(instance.getMtu());
      this.withNetworkType(instance.getNetworkType());
      this.withFeatures(instance.getFeatures());
      this.withMtu(instance.getMtu());
      this.withNetworkType(instance.getNetworkType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkMigrationFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkMigration build() {
    NetworkMigration buildable = new NetworkMigration(fluent.buildFeatures(),fluent.buildMtu(),fluent.getNetworkType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}