package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkSpecBuilder extends NetworkSpecFluent<NetworkSpecBuilder> implements VisitableBuilder<NetworkSpec,NetworkSpecBuilder>{
  public NetworkSpecBuilder() {
    this(false);
  }
  public NetworkSpecBuilder(Boolean validationEnabled) {
    this(new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkSpec());

    if (instance != null) {
      fluent.withAdditionalNetworks(instance.getAdditionalNetworks());
      fluent.withClusterNetwork(instance.getClusterNetwork());
      fluent.withDefaultNetwork(instance.getDefaultNetwork());
      fluent.withDeployKubeProxy(instance.getDeployKubeProxy());
      fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork());
      fluent.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
      fluent.withExportNetworkFlows(instance.getExportNetworkFlows());
      fluent.withKubeProxyConfig(instance.getKubeProxyConfig());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withMigration(instance.getMigration());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
      fluent.withAdditionalNetworks(instance.getAdditionalNetworks());
      fluent.withClusterNetwork(instance.getClusterNetwork());
      fluent.withDefaultNetwork(instance.getDefaultNetwork());
      fluent.withDeployKubeProxy(instance.getDeployKubeProxy());
      fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork());
      fluent.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
      fluent.withExportNetworkFlows(instance.getExportNetworkFlows());
      fluent.withKubeProxyConfig(instance.getKubeProxyConfig());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withMigration(instance.getMigration());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkSpecBuilder(NetworkSpec instance) {
    this(instance,false);
  }
  public NetworkSpecBuilder(NetworkSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkSpec());

    if (instance != null) {
      this.withAdditionalNetworks(instance.getAdditionalNetworks());
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withDefaultNetwork(instance.getDefaultNetwork());
      this.withDeployKubeProxy(instance.getDeployKubeProxy());
      this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
      this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
      this.withExportNetworkFlows(instance.getExportNetworkFlows());
      this.withKubeProxyConfig(instance.getKubeProxyConfig());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withMigration(instance.getMigration());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
      this.withAdditionalNetworks(instance.getAdditionalNetworks());
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withDefaultNetwork(instance.getDefaultNetwork());
      this.withDeployKubeProxy(instance.getDeployKubeProxy());
      this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
      this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
      this.withExportNetworkFlows(instance.getExportNetworkFlows());
      this.withKubeProxyConfig(instance.getKubeProxyConfig());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withMigration(instance.getMigration());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkSpec build() {
    NetworkSpec buildable = new NetworkSpec(fluent.buildAdditionalNetworks(),fluent.buildClusterNetwork(),fluent.buildDefaultNetwork(),fluent.getDeployKubeProxy(),fluent.getDisableMultiNetwork(),fluent.getDisableNetworkDiagnostics(),fluent.buildExportNetworkFlows(),fluent.buildKubeProxyConfig(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildMigration(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getServiceNetwork(),fluent.buildUnsupportedConfigOverrides(),fluent.getUseMultiNetworkPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}