package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodePortStrategyBuilder extends NodePortStrategyFluent<NodePortStrategyBuilder> implements VisitableBuilder<NodePortStrategy,NodePortStrategyBuilder>{
  public NodePortStrategyBuilder() {
    this(false);
  }
  public NodePortStrategyBuilder(Boolean validationEnabled) {
    this(new NodePortStrategy(), validationEnabled);
  }
  public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodePortStrategy(), validationEnabled);
  }
  public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,NodePortStrategy instance) {
    this(fluent, instance, false);
  }
  public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,NodePortStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodePortStrategy());

    if (instance != null) {
      fluent.withProtocol(instance.getProtocol());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodePortStrategyBuilder(NodePortStrategy instance) {
    this(instance,false);
  }
  public NodePortStrategyBuilder(NodePortStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodePortStrategy());

    if (instance != null) {
      this.withProtocol(instance.getProtocol());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodePortStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public NodePortStrategy build() {
    NodePortStrategy buildable = new NodePortStrategy(fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}