package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(false);
  }
  public NodeStatusBuilder(Boolean validationEnabled) {
    this(new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
    this(fluent, instance, false);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeStatus());

    if (instance != null) {
      fluent.withCurrentRevision(instance.getCurrentRevision());
      fluent.withLastFailedCount(instance.getLastFailedCount());
      fluent.withLastFailedReason(instance.getLastFailedReason());
      fluent.withLastFailedRevision(instance.getLastFailedRevision());
      fluent.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
      fluent.withLastFailedTime(instance.getLastFailedTime());
      fluent.withLastFallbackCount(instance.getLastFallbackCount());
      fluent.withNodeName(instance.getNodeName());
      fluent.withTargetRevision(instance.getTargetRevision());
      fluent.withCurrentRevision(instance.getCurrentRevision());
      fluent.withLastFailedCount(instance.getLastFailedCount());
      fluent.withLastFailedReason(instance.getLastFailedReason());
      fluent.withLastFailedRevision(instance.getLastFailedRevision());
      fluent.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
      fluent.withLastFailedTime(instance.getLastFailedTime());
      fluent.withLastFallbackCount(instance.getLastFallbackCount());
      fluent.withNodeName(instance.getNodeName());
      fluent.withTargetRevision(instance.getTargetRevision());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeStatusBuilder(NodeStatus instance) {
    this(instance,false);
  }
  public NodeStatusBuilder(NodeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeStatus());

    if (instance != null) {
      this.withCurrentRevision(instance.getCurrentRevision());
      this.withLastFailedCount(instance.getLastFailedCount());
      this.withLastFailedReason(instance.getLastFailedReason());
      this.withLastFailedRevision(instance.getLastFailedRevision());
      this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
      this.withLastFailedTime(instance.getLastFailedTime());
      this.withLastFallbackCount(instance.getLastFallbackCount());
      this.withNodeName(instance.getNodeName());
      this.withTargetRevision(instance.getTargetRevision());
      this.withCurrentRevision(instance.getCurrentRevision());
      this.withLastFailedCount(instance.getLastFailedCount());
      this.withLastFailedReason(instance.getLastFailedReason());
      this.withLastFailedRevision(instance.getLastFailedRevision());
      this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
      this.withLastFailedTime(instance.getLastFailedTime());
      this.withLastFallbackCount(instance.getLastFallbackCount());
      this.withNodeName(instance.getNodeName());
      this.withTargetRevision(instance.getTargetRevision());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.getCurrentRevision(),fluent.getLastFailedCount(),fluent.getLastFailedReason(),fluent.getLastFailedRevision(),fluent.getLastFailedRevisionErrors(),fluent.getLastFailedTime(),fluent.getLastFallbackCount(),fluent.getNodeName(),fluent.getTargetRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}