package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OVNKubernetesConfigBuilder extends OVNKubernetesConfigFluent<OVNKubernetesConfigBuilder> implements VisitableBuilder<OVNKubernetesConfig,OVNKubernetesConfigBuilder>{
  public OVNKubernetesConfigBuilder() {
    this(false);
  }
  public OVNKubernetesConfigBuilder(Boolean validationEnabled) {
    this(new OVNKubernetesConfig(), validationEnabled);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OVNKubernetesConfig(), validationEnabled);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance) {
    this(fluent, instance, false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OVNKubernetesConfig());

    if (instance != null) {
      fluent.withEgressIPConfig(instance.getEgressIPConfig());
      fluent.withGatewayConfig(instance.getGatewayConfig());
      fluent.withGenevePort(instance.getGenevePort());
      fluent.withHybridOverlayConfig(instance.getHybridOverlayConfig());
      fluent.withIpsecConfig(instance.getIpsecConfig());
      fluent.withMtu(instance.getMtu());
      fluent.withPolicyAuditConfig(instance.getPolicyAuditConfig());
      fluent.withV4InternalSubnet(instance.getV4InternalSubnet());
      fluent.withV6InternalSubnet(instance.getV6InternalSubnet());
      fluent.withEgressIPConfig(instance.getEgressIPConfig());
      fluent.withGatewayConfig(instance.getGatewayConfig());
      fluent.withGenevePort(instance.getGenevePort());
      fluent.withHybridOverlayConfig(instance.getHybridOverlayConfig());
      fluent.withIpsecConfig(instance.getIpsecConfig());
      fluent.withMtu(instance.getMtu());
      fluent.withPolicyAuditConfig(instance.getPolicyAuditConfig());
      fluent.withV4InternalSubnet(instance.getV4InternalSubnet());
      fluent.withV6InternalSubnet(instance.getV6InternalSubnet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance) {
    this(instance,false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OVNKubernetesConfig());

    if (instance != null) {
      this.withEgressIPConfig(instance.getEgressIPConfig());
      this.withGatewayConfig(instance.getGatewayConfig());
      this.withGenevePort(instance.getGenevePort());
      this.withHybridOverlayConfig(instance.getHybridOverlayConfig());
      this.withIpsecConfig(instance.getIpsecConfig());
      this.withMtu(instance.getMtu());
      this.withPolicyAuditConfig(instance.getPolicyAuditConfig());
      this.withV4InternalSubnet(instance.getV4InternalSubnet());
      this.withV6InternalSubnet(instance.getV6InternalSubnet());
      this.withEgressIPConfig(instance.getEgressIPConfig());
      this.withGatewayConfig(instance.getGatewayConfig());
      this.withGenevePort(instance.getGenevePort());
      this.withHybridOverlayConfig(instance.getHybridOverlayConfig());
      this.withIpsecConfig(instance.getIpsecConfig());
      this.withMtu(instance.getMtu());
      this.withPolicyAuditConfig(instance.getPolicyAuditConfig());
      this.withV4InternalSubnet(instance.getV4InternalSubnet());
      this.withV6InternalSubnet(instance.getV6InternalSubnet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OVNKubernetesConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OVNKubernetesConfig build() {
    OVNKubernetesConfig buildable = new OVNKubernetesConfig(fluent.buildEgressIPConfig(),fluent.buildGatewayConfig(),fluent.getGenevePort(),fluent.buildHybridOverlayConfig(),fluent.buildIpsecConfig(),fluent.getMtu(),fluent.buildPolicyAuditConfig(),fluent.getV4InternalSubnet(),fluent.getV6InternalSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}