package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftAPIServerBuilder extends OpenShiftAPIServerFluent<OpenShiftAPIServerBuilder> implements VisitableBuilder<OpenShiftAPIServer,OpenShiftAPIServerBuilder>{
  public OpenShiftAPIServerBuilder() {
    this(false);
  }
  public OpenShiftAPIServerBuilder(Boolean validationEnabled) {
    this(new OpenShiftAPIServer(), validationEnabled);
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftAPIServer(), validationEnabled);
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,OpenShiftAPIServer instance) {
    this(fluent, instance, false);
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,OpenShiftAPIServer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenShiftAPIServer());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServer instance) {
    this(instance,false);
  }
  public OpenShiftAPIServerBuilder(OpenShiftAPIServer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenShiftAPIServer());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenShiftAPIServerFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftAPIServer build() {
    OpenShiftAPIServer buildable = new OpenShiftAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}