package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftControllerManagerListBuilder extends OpenShiftControllerManagerListFluent<OpenShiftControllerManagerListBuilder> implements VisitableBuilder<OpenShiftControllerManagerList,OpenShiftControllerManagerListBuilder>{
  public OpenShiftControllerManagerListBuilder() {
    this(false);
  }
  public OpenShiftControllerManagerListBuilder(Boolean validationEnabled) {
    this(new OpenShiftControllerManagerList(), validationEnabled);
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftControllerManagerList(), validationEnabled);
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,OpenShiftControllerManagerList instance) {
    this(fluent, instance, false);
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,OpenShiftControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenShiftControllerManagerList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerList instance) {
    this(instance,false);
  }
  public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenShiftControllerManagerList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenShiftControllerManagerListFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftControllerManagerList build() {
    OpenShiftControllerManagerList buildable = new OpenShiftControllerManagerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}