package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerspectiveBuilder extends PerspectiveFluent<PerspectiveBuilder> implements VisitableBuilder<Perspective,PerspectiveBuilder>{
  public PerspectiveBuilder() {
    this(false);
  }
  public PerspectiveBuilder(Boolean validationEnabled) {
    this(new Perspective(), validationEnabled);
  }
  public PerspectiveBuilder(PerspectiveFluent<?> fluent) {
    this(fluent, false);
  }
  public PerspectiveBuilder(PerspectiveFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Perspective(), validationEnabled);
  }
  public PerspectiveBuilder(PerspectiveFluent<?> fluent,Perspective instance) {
    this(fluent, instance, false);
  }
  public PerspectiveBuilder(PerspectiveFluent<?> fluent,Perspective instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Perspective());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withPinnedResources(instance.getPinnedResources());
      fluent.withVisibility(instance.getVisibility());
      fluent.withId(instance.getId());
      fluent.withPinnedResources(instance.getPinnedResources());
      fluent.withVisibility(instance.getVisibility());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PerspectiveBuilder(Perspective instance) {
    this(instance,false);
  }
  public PerspectiveBuilder(Perspective instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Perspective());

    if (instance != null) {
      this.withId(instance.getId());
      this.withPinnedResources(instance.getPinnedResources());
      this.withVisibility(instance.getVisibility());
      this.withId(instance.getId());
      this.withPinnedResources(instance.getPinnedResources());
      this.withVisibility(instance.getVisibility());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PerspectiveFluent<?> fluent;
  Boolean validationEnabled;
  public Perspective build() {
    Perspective buildable = new Perspective(fluent.getId(),fluent.buildPinnedResources(),fluent.buildVisibility());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}