package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerspectiveVisibilityBuilder extends PerspectiveVisibilityFluent<PerspectiveVisibilityBuilder> implements VisitableBuilder<PerspectiveVisibility,PerspectiveVisibilityBuilder>{
  public PerspectiveVisibilityBuilder() {
    this(false);
  }
  public PerspectiveVisibilityBuilder(Boolean validationEnabled) {
    this(new PerspectiveVisibility(), validationEnabled);
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibilityFluent<?> fluent) {
    this(fluent, false);
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibilityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PerspectiveVisibility(), validationEnabled);
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibilityFluent<?> fluent,PerspectiveVisibility instance) {
    this(fluent, instance, false);
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibilityFluent<?> fluent,PerspectiveVisibility instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PerspectiveVisibility());

    if (instance != null) {
      fluent.withAccessReview(instance.getAccessReview());
      fluent.withState(instance.getState());
      fluent.withAccessReview(instance.getAccessReview());
      fluent.withState(instance.getState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibility instance) {
    this(instance,false);
  }
  public PerspectiveVisibilityBuilder(PerspectiveVisibility instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PerspectiveVisibility());

    if (instance != null) {
      this.withAccessReview(instance.getAccessReview());
      this.withState(instance.getState());
      this.withAccessReview(instance.getAccessReview());
      this.withState(instance.getState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PerspectiveVisibilityFluent<?> fluent;
  Boolean validationEnabled;
  public PerspectiveVisibility build() {
    PerspectiveVisibility buildable = new PerspectiveVisibility(fluent.buildAccessReview(),fluent.getState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}