package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProviderLoadBalancerParametersBuilder extends ProviderLoadBalancerParametersFluent<ProviderLoadBalancerParametersBuilder> implements VisitableBuilder<ProviderLoadBalancerParameters,ProviderLoadBalancerParametersBuilder>{
  public ProviderLoadBalancerParametersBuilder() {
    this(false);
  }
  public ProviderLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new ProviderLoadBalancerParameters(), validationEnabled);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProviderLoadBalancerParameters(), validationEnabled);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProviderLoadBalancerParameters());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withGcp(instance.getGcp());
      fluent.withIbm(instance.getIbm());
      fluent.withType(instance.getType());
      fluent.withAws(instance.getAws());
      fluent.withGcp(instance.getGcp());
      fluent.withIbm(instance.getIbm());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance) {
    this(instance,false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProviderLoadBalancerParameters());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withGcp(instance.getGcp());
      this.withIbm(instance.getIbm());
      this.withType(instance.getType());
      this.withAws(instance.getAws());
      this.withGcp(instance.getGcp());
      this.withIbm(instance.getIbm());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProviderLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public ProviderLoadBalancerParameters build() {
    ProviderLoadBalancerParameters buildable = new ProviderLoadBalancerParameters(fluent.buildAws(),fluent.buildGcp(),fluent.buildIbm(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}