package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerBuilder extends ServerFluent<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder>{
  public ServerBuilder() {
    this(false);
  }
  public ServerBuilder(Boolean validationEnabled) {
    this(new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance) {
    this(fluent, instance, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Server());

    if (instance != null) {
      fluent.withForwardPlugin(instance.getForwardPlugin());
      fluent.withName(instance.getName());
      fluent.withZones(instance.getZones());
      fluent.withForwardPlugin(instance.getForwardPlugin());
      fluent.withName(instance.getName());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerBuilder(Server instance) {
    this(instance,false);
  }
  public ServerBuilder(Server instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Server());

    if (instance != null) {
      this.withForwardPlugin(instance.getForwardPlugin());
      this.withName(instance.getName());
      this.withZones(instance.getZones());
      this.withForwardPlugin(instance.getForwardPlugin());
      this.withName(instance.getName());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerFluent<?> fluent;
  Boolean validationEnabled;
  public Server build() {
    Server buildable = new Server(fluent.buildForwardPlugin(),fluent.getName(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}