package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StaticIPAMConfigBuilder extends StaticIPAMConfigFluent<StaticIPAMConfigBuilder> implements VisitableBuilder<StaticIPAMConfig,StaticIPAMConfigBuilder>{
  public StaticIPAMConfigBuilder() {
    this(false);
  }
  public StaticIPAMConfigBuilder(Boolean validationEnabled) {
    this(new StaticIPAMConfig(), validationEnabled);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StaticIPAMConfig(), validationEnabled);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance) {
    this(fluent, instance, false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StaticIPAMConfig());

    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withDns(instance.getDns());
      fluent.withRoutes(instance.getRoutes());
      fluent.withAddresses(instance.getAddresses());
      fluent.withDns(instance.getDns());
      fluent.withRoutes(instance.getRoutes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfig instance) {
    this(instance,false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StaticIPAMConfig());

    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withDns(instance.getDns());
      this.withRoutes(instance.getRoutes());
      this.withAddresses(instance.getAddresses());
      this.withDns(instance.getDns());
      this.withRoutes(instance.getRoutes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StaticIPAMConfigFluent<?> fluent;
  Boolean validationEnabled;
  public StaticIPAMConfig build() {
    StaticIPAMConfig buildable = new StaticIPAMConfig(fluent.buildAddresses(),fluent.buildDns(),fluent.buildRoutes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}