package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageSpecBuilder extends StorageSpecFluent<StorageSpecBuilder> implements VisitableBuilder<StorageSpec,StorageSpecBuilder>{
  public StorageSpecBuilder() {
    this(false);
  }
  public StorageSpecBuilder(Boolean validationEnabled) {
    this(new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance) {
    this(fluent, instance, false);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageSpec());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withVsphereStorageDriver(instance.getVsphereStorageDriver());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withVsphereStorageDriver(instance.getVsphereStorageDriver());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageSpecBuilder(StorageSpec instance) {
    this(instance,false);
  }
  public StorageSpecBuilder(StorageSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageSpec());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withVsphereStorageDriver(instance.getVsphereStorageDriver());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withVsphereStorageDriver(instance.getVsphereStorageDriver());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StorageSpec build() {
    StorageSpec buildable = new StorageSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides(),fluent.getVsphereStorageDriver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}