package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentSourcePolicyBuilder extends ImageContentSourcePolicyFluent<ImageContentSourcePolicyBuilder> implements VisitableBuilder<ImageContentSourcePolicy,ImageContentSourcePolicyBuilder>{
  public ImageContentSourcePolicyBuilder() {
    this(false);
  }
  public ImageContentSourcePolicyBuilder(Boolean validationEnabled) {
    this(new ImageContentSourcePolicy(), validationEnabled);
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentSourcePolicy(), validationEnabled);
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicyFluent<?> fluent,ImageContentSourcePolicy instance) {
    this(fluent, instance, false);
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicyFluent<?> fluent,ImageContentSourcePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageContentSourcePolicy());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicy instance) {
    this(instance,false);
  }
  public ImageContentSourcePolicyBuilder(ImageContentSourcePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageContentSourcePolicy());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageContentSourcePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentSourcePolicy build() {
    ImageContentSourcePolicy buildable = new ImageContentSourcePolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}