package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EndpointPublishingStrategyFluent<A extends EndpointPublishingStrategyFluent<A>> extends BaseFluent<A>{
  public EndpointPublishingStrategyFluent() {
  }
  
  public EndpointPublishingStrategyFluent(EndpointPublishingStrategy instance) {
    this.copyInstance(instance);
  }
  private HostNetworkStrategyBuilder hostNetwork;
  private LoadBalancerStrategyBuilder loadBalancer;
  private NodePortStrategyBuilder nodePort;
  private PrivateStrategyBuilder _private;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EndpointPublishingStrategy instance) {
    instance = (instance != null ? instance : new EndpointPublishingStrategy());
  
    if (instance != null) {
        this.withHostNetwork(instance.getHostNetwork());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withNodePort(instance.getNodePort());
        this.withPrivate(instance.getPrivate());
        this.withType(instance.getType());
        this.withHostNetwork(instance.getHostNetwork());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withNodePort(instance.getNodePort());
        this.withPrivate(instance.getPrivate());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public HostNetworkStrategy buildHostNetwork() {
    return this.hostNetwork!=null ?this.hostNetwork.build():null;
  }
  
  public A withHostNetwork(HostNetworkStrategy hostNetwork) {
    _visitables.get("hostNetwork").remove(this.hostNetwork);
    if (hostNetwork!=null){ this.hostNetwork= new HostNetworkStrategyBuilder(hostNetwork); _visitables.get("hostNetwork").add(this.hostNetwork);} else { this.hostNetwork = null; _visitables.get("hostNetwork").remove(this.hostNetwork); } return (A) this;
  }
  
  public boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  
  public A withNewHostNetwork(Integer httpPort,Integer httpsPort,String protocol,Integer statsPort) {
    return (A)withHostNetwork(new HostNetworkStrategy(httpPort, httpsPort, protocol, statsPort));
  }
  
  public HostNetworkNested<A> withNewHostNetwork() {
    return new HostNetworkNested(null);
  }
  
  public HostNetworkNested<A> withNewHostNetworkLike(HostNetworkStrategy item) {
    return new HostNetworkNested(item);
  }
  
  public HostNetworkNested<A> editHostNetwork() {
    return withNewHostNetworkLike(java.util.Optional.ofNullable(buildHostNetwork()).orElse(null));
  }
  
  public HostNetworkNested<A> editOrNewHostNetwork() {
    return withNewHostNetworkLike(java.util.Optional.ofNullable(buildHostNetwork()).orElse(new HostNetworkStrategyBuilder().build()));
  }
  
  public HostNetworkNested<A> editOrNewHostNetworkLike(HostNetworkStrategy item) {
    return withNewHostNetworkLike(java.util.Optional.ofNullable(buildHostNetwork()).orElse(item));
  }
  
  public LoadBalancerStrategy buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  
  public A withLoadBalancer(LoadBalancerStrategy loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStrategyBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public LoadBalancerNested<A> withNewLoadBalancer() {
    return new LoadBalancerNested(null);
  }
  
  public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStrategy item) {
    return new LoadBalancerNested(item);
  }
  
  public LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(null));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(new LoadBalancerStrategyBuilder().build()));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStrategy item) {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(item));
  }
  
  public NodePortStrategy buildNodePort() {
    return this.nodePort!=null ?this.nodePort.build():null;
  }
  
  public A withNodePort(NodePortStrategy nodePort) {
    _visitables.get("nodePort").remove(this.nodePort);
    if (nodePort!=null){ this.nodePort= new NodePortStrategyBuilder(nodePort); _visitables.get("nodePort").add(this.nodePort);} else { this.nodePort = null; _visitables.get("nodePort").remove(this.nodePort); } return (A) this;
  }
  
  public boolean hasNodePort() {
    return this.nodePort != null;
  }
  
  public A withNewNodePort(String protocol) {
    return (A)withNodePort(new NodePortStrategy(protocol));
  }
  
  public NodePortNested<A> withNewNodePort() {
    return new NodePortNested(null);
  }
  
  public NodePortNested<A> withNewNodePortLike(NodePortStrategy item) {
    return new NodePortNested(item);
  }
  
  public NodePortNested<A> editNodePort() {
    return withNewNodePortLike(java.util.Optional.ofNullable(buildNodePort()).orElse(null));
  }
  
  public NodePortNested<A> editOrNewNodePort() {
    return withNewNodePortLike(java.util.Optional.ofNullable(buildNodePort()).orElse(new NodePortStrategyBuilder().build()));
  }
  
  public NodePortNested<A> editOrNewNodePortLike(NodePortStrategy item) {
    return withNewNodePortLike(java.util.Optional.ofNullable(buildNodePort()).orElse(item));
  }
  
  public PrivateStrategy buildPrivate() {
    return this._private!=null ?this._private.build():null;
  }
  
  public A withPrivate(PrivateStrategy _private) {
    _visitables.get("_private").remove(this._private);
    if (_private!=null){ this._private= new PrivateStrategyBuilder(_private); _visitables.get("_private").add(this._private);} else { this._private = null; _visitables.get("_private").remove(this._private); } return (A) this;
  }
  
  public boolean hasPrivate() {
    return this._private != null;
  }
  
  public A withNewPrivate(String protocol) {
    return (A)withPrivate(new PrivateStrategy(protocol));
  }
  
  public PrivateNested<A> withNewPrivate() {
    return new PrivateNested(null);
  }
  
  public PrivateNested<A> withNewPrivateLike(PrivateStrategy item) {
    return new PrivateNested(item);
  }
  
  public PrivateNested<A> editPrivate() {
    return withNewPrivateLike(java.util.Optional.ofNullable(buildPrivate()).orElse(null));
  }
  
  public PrivateNested<A> editOrNewPrivate() {
    return withNewPrivateLike(java.util.Optional.ofNullable(buildPrivate()).orElse(new PrivateStrategyBuilder().build()));
  }
  
  public PrivateNested<A> editOrNewPrivateLike(PrivateStrategy item) {
    return withNewPrivateLike(java.util.Optional.ofNullable(buildPrivate()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointPublishingStrategyFluent that = (EndpointPublishingStrategyFluent) o;
    if (!java.util.Objects.equals(hostNetwork, that.hostNetwork)) return false;
  
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
  
    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;
  
    if (!java.util.Objects.equals(_private, that._private)) return false;
  
    if (!java.util.Objects.equals(type, that.type)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostNetwork,  loadBalancer,  nodePort,  _private,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (_private != null) { sb.append("_private:"); sb.append(_private + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HostNetworkNested<N> extends HostNetworkStrategyFluent<HostNetworkNested<N>> implements Nested<N>{
    HostNetworkNested(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyBuilder builder;
    
    public N and() {
      return (N) EndpointPublishingStrategyFluent.this.withHostNetwork(builder.build());
    }
    
    public N endHostNetwork() {
      return and();
    }
    
  
  }
  public class LoadBalancerNested<N> extends LoadBalancerStrategyFluent<LoadBalancerNested<N>> implements Nested<N>{
    LoadBalancerNested(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyBuilder builder;
    
    public N and() {
      return (N) EndpointPublishingStrategyFluent.this.withLoadBalancer(builder.build());
    }
    
    public N endLoadBalancer() {
      return and();
    }
    
  
  }
  public class NodePortNested<N> extends NodePortStrategyFluent<NodePortNested<N>> implements Nested<N>{
    NodePortNested(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyBuilder builder;
    
    public N and() {
      return (N) EndpointPublishingStrategyFluent.this.withNodePort(builder.build());
    }
    
    public N endNodePort() {
      return and();
    }
    
  
  }
  public class PrivateNested<N> extends PrivateStrategyFluent<PrivateNested<N>> implements Nested<N>{
    PrivateNested(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyBuilder builder;
    
    public N and() {
      return (N) EndpointPublishingStrategyFluent.this.withPrivate(builder.build());
    }
    
    public N endPrivate() {
      return and();
    }
    
  
  }

}