package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GenerationStatusFluent<A extends GenerationStatusFluent<A>> extends BaseFluent<A>{
  public GenerationStatusFluent() {
  }
  
  public GenerationStatusFluent(GenerationStatus instance) {
    this.copyInstance(instance);
  }
  private String group;
  private String hash;
  private Long lastGeneration;
  private String name;
  private String namespace;
  private String resource;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GenerationStatus instance) {
    instance = (instance != null ? instance : new GenerationStatus());
  
    if (instance != null) {
        this.withGroup(instance.getGroup());
        this.withHash(instance.getHash());
        this.withLastGeneration(instance.getLastGeneration());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResource(instance.getResource());
        this.withGroup(instance.getGroup());
        this.withHash(instance.getHash());
        this.withLastGeneration(instance.getLastGeneration());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResource(instance.getResource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getHash() {
    return this.hash;
  }
  
  public A withHash(String hash) {
    this.hash=hash; return (A) this;
  }
  
  public boolean hasHash() {
    return this.hash != null;
  }
  
  public Long getLastGeneration() {
    return this.lastGeneration;
  }
  
  public A withLastGeneration(Long lastGeneration) {
    this.lastGeneration=lastGeneration; return (A) this;
  }
  
  public boolean hasLastGeneration() {
    return this.lastGeneration != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GenerationStatusFluent that = (GenerationStatusFluent) o;
    if (!java.util.Objects.equals(group, that.group)) return false;
  
    if (!java.util.Objects.equals(hash, that.hash)) return false;
  
    if (!java.util.Objects.equals(lastGeneration, that.lastGeneration)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
  
    if (!java.util.Objects.equals(resource, that.resource)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(group,  hash,  lastGeneration,  name,  namespace,  resource,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (hash != null) { sb.append("hash:"); sb.append(hash + ","); }
    if (lastGeneration != null) { sb.append("lastGeneration:"); sb.append(lastGeneration + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}