package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressControllerHTTPHeadersFluent<A extends IngressControllerHTTPHeadersFluent<A>> extends BaseFluent<A>{
  public IngressControllerHTTPHeadersFluent() {
  }
  
  public IngressControllerHTTPHeadersFluent(IngressControllerHTTPHeaders instance) {
    this.copyInstance(instance);
  }
  private String forwardedHeaderPolicy;
  private List<String> headerNameCaseAdjustments = new ArrayList<String>();
  private IngressControllerHTTPUniqueIdHeaderPolicyBuilder uniqueId;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressControllerHTTPHeaders instance) {
    instance = (instance != null ? instance : new IngressControllerHTTPHeaders());
  
    if (instance != null) {
        this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy());
        this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments());
        this.withUniqueId(instance.getUniqueId());
        this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy());
        this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments());
        this.withUniqueId(instance.getUniqueId());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getForwardedHeaderPolicy() {
    return this.forwardedHeaderPolicy;
  }
  
  public A withForwardedHeaderPolicy(String forwardedHeaderPolicy) {
    this.forwardedHeaderPolicy=forwardedHeaderPolicy; return (A) this;
  }
  
  public boolean hasForwardedHeaderPolicy() {
    return this.forwardedHeaderPolicy != null;
  }
  
  public A addToHeaderNameCaseAdjustments(int index,String item) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    this.headerNameCaseAdjustments.add(index, item);
    return (A)this;
  }
  
  public A setToHeaderNameCaseAdjustments(int index,String item) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    this.headerNameCaseAdjustments.set(index, item); return (A)this;
  }
  
  public A addToHeaderNameCaseAdjustments(java.lang.String... items) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    for (String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
  }
  
  public A addAllToHeaderNameCaseAdjustments(Collection<String> items) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    for (String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
  }
  
  public A removeFromHeaderNameCaseAdjustments(java.lang.String... items) {
    if (this.headerNameCaseAdjustments == null) return (A)this;
    for (String item : items) { this.headerNameCaseAdjustments.remove(item);} return (A)this;
  }
  
  public A removeAllFromHeaderNameCaseAdjustments(Collection<String> items) {
    if (this.headerNameCaseAdjustments == null) return (A)this;
    for (String item : items) { this.headerNameCaseAdjustments.remove(item);} return (A)this;
  }
  
  public List<String> getHeaderNameCaseAdjustments() {
    return this.headerNameCaseAdjustments;
  }
  
  public String getHeaderNameCaseAdjustment(int index) {
    return this.headerNameCaseAdjustments.get(index);
  }
  
  public String getFirstHeaderNameCaseAdjustment() {
    return this.headerNameCaseAdjustments.get(0);
  }
  
  public String getLastHeaderNameCaseAdjustment() {
    return this.headerNameCaseAdjustments.get(headerNameCaseAdjustments.size() - 1);
  }
  
  public String getMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
    for (String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
    for (String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withHeaderNameCaseAdjustments(List<String> headerNameCaseAdjustments) {
    if (headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments = new ArrayList(); for (String item : headerNameCaseAdjustments){this.addToHeaderNameCaseAdjustments(item);}} else { this.headerNameCaseAdjustments = null;} return (A) this;
  }
  
  public A withHeaderNameCaseAdjustments(java.lang.String... headerNameCaseAdjustments) {
    if (this.headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments.clear(); _visitables.remove("headerNameCaseAdjustments"); }
    if (headerNameCaseAdjustments != null) {for (String item :headerNameCaseAdjustments){ this.addToHeaderNameCaseAdjustments(item);}} return (A) this;
  }
  
  public boolean hasHeaderNameCaseAdjustments() {
    return headerNameCaseAdjustments != null && !headerNameCaseAdjustments.isEmpty();
  }
  
  public IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId() {
    return this.uniqueId!=null ?this.uniqueId.build():null;
  }
  
  public A withUniqueId(IngressControllerHTTPUniqueIdHeaderPolicy uniqueId) {
    _visitables.get("uniqueId").remove(this.uniqueId);
    if (uniqueId!=null){ this.uniqueId= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(uniqueId); _visitables.get("uniqueId").add(this.uniqueId);} else { this.uniqueId = null; _visitables.get("uniqueId").remove(this.uniqueId); } return (A) this;
  }
  
  public boolean hasUniqueId() {
    return this.uniqueId != null;
  }
  
  public A withNewUniqueId(String format,String name) {
    return (A)withUniqueId(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  
  public UniqueIdNested<A> withNewUniqueId() {
    return new UniqueIdNested(null);
  }
  
  public UniqueIdNested<A> withNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new UniqueIdNested(item);
  }
  
  public UniqueIdNested<A> editUniqueId() {
    return withNewUniqueIdLike(java.util.Optional.ofNullable(buildUniqueId()).orElse(null));
  }
  
  public UniqueIdNested<A> editOrNewUniqueId() {
    return withNewUniqueIdLike(java.util.Optional.ofNullable(buildUniqueId()).orElse(new IngressControllerHTTPUniqueIdHeaderPolicyBuilder().build()));
  }
  
  public UniqueIdNested<A> editOrNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return withNewUniqueIdLike(java.util.Optional.ofNullable(buildUniqueId()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressControllerHTTPHeadersFluent that = (IngressControllerHTTPHeadersFluent) o;
    if (!java.util.Objects.equals(forwardedHeaderPolicy, that.forwardedHeaderPolicy)) return false;
  
    if (!java.util.Objects.equals(headerNameCaseAdjustments, that.headerNameCaseAdjustments)) return false;
  
    if (!java.util.Objects.equals(uniqueId, that.uniqueId)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(forwardedHeaderPolicy,  headerNameCaseAdjustments,  uniqueId,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forwardedHeaderPolicy != null) { sb.append("forwardedHeaderPolicy:"); sb.append(forwardedHeaderPolicy + ","); }
    if (headerNameCaseAdjustments != null && !headerNameCaseAdjustments.isEmpty()) { sb.append("headerNameCaseAdjustments:"); sb.append(headerNameCaseAdjustments + ","); }
    if (uniqueId != null) { sb.append("uniqueId:"); sb.append(uniqueId + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class UniqueIdNested<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluent<UniqueIdNested<N>> implements Nested<N>{
    UniqueIdNested(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    
    public N and() {
      return (N) IngressControllerHTTPHeadersFluent.this.withUniqueId(builder.build());
    }
    
    public N endUniqueId() {
      return and();
    }
    
  
  }

}