package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubeControllerManagerStatusFluent<A extends KubeControllerManagerStatusFluent<A>> extends BaseFluent<A>{
  public KubeControllerManagerStatusFluent() {
  }
  
  public KubeControllerManagerStatusFluent(KubeControllerManagerStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
  private ArrayList<GenerationStatusBuilder> generations = new ArrayList<GenerationStatusBuilder>();
  private Integer latestAvailableRevision;
  private String latestAvailableRevisionReason;
  private ArrayList<NodeStatusBuilder> nodeStatuses = new ArrayList<NodeStatusBuilder>();
  private Long observedGeneration;
  private Integer readyReplicas;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KubeControllerManagerStatus instance) {
    instance = (instance != null ? instance : new KubeControllerManagerStatus());
  
    if (instance != null) {
        this.withConditions(instance.getConditions());
        this.withGenerations(instance.getGenerations());
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
        this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
        this.withNodeStatuses(instance.getNodeStatuses());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withVersion(instance.getVersion());
        this.withConditions(instance.getConditions());
        this.withGenerations(instance.getGenerations());
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
        this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
        this.withNodeStatuses(instance.getNodeStatuses());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withVersion(instance.getVersion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OperatorCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public OperatorCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<OperatorCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= generations.size()) { _visitables.get("generations").add(builder); generations.add(builder); } else { _visitables.get("generations").add(index, builder); generations.add(index, builder);}
    return (A)this;
  }
  
  public A setToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= generations.size()) { _visitables.get("generations").add(builder); generations.add(builder); } else { _visitables.get("generations").set(index, builder); generations.set(index, builder);}
    return (A)this;
  }
  
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  
  public A addAllToGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) return (A)this;
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) return (A)this;
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<GenerationStatusBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      GenerationStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GenerationStatus> buildGenerations() {
    return generations != null ? build(generations) : null;
  }
  
  public GenerationStatus buildGeneration(int index) {
    return this.generations.get(index).build();
  }
  
  public GenerationStatus buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  
  public GenerationStatus buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withGenerations(List<GenerationStatus> generations) {
    if (this.generations != null) { _visitables.get("generations").clear();}
    if (generations != null) {this.generations = new ArrayList(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear(); _visitables.remove("generations"); }
    if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  
  public boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  
  public GenerationsNested<A> addNewGeneration() {
    return new GenerationsNested(-1, null);
  }
  
  public GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
    return new GenerationsNested(-1, item);
  }
  
  public GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item) {
    return new GenerationsNested(index, item);
  }
  
  public GenerationsNested<A> editGeneration(int index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  
  public GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public Integer getLatestAvailableRevision() {
    return this.latestAvailableRevision;
  }
  
  public A withLatestAvailableRevision(Integer latestAvailableRevision) {
    this.latestAvailableRevision=latestAvailableRevision; return (A) this;
  }
  
  public boolean hasLatestAvailableRevision() {
    return this.latestAvailableRevision != null;
  }
  
  public String getLatestAvailableRevisionReason() {
    return this.latestAvailableRevisionReason;
  }
  
  public A withLatestAvailableRevisionReason(String latestAvailableRevisionReason) {
    this.latestAvailableRevisionReason=latestAvailableRevisionReason; return (A) this;
  }
  
  public boolean hasLatestAvailableRevisionReason() {
    return this.latestAvailableRevisionReason != null;
  }
  
  public A addToNodeStatuses(int index,NodeStatus item) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    NodeStatusBuilder builder = new NodeStatusBuilder(item);
    if (index < 0 || index >= nodeStatuses.size()) { _visitables.get("nodeStatuses").add(builder); nodeStatuses.add(builder); } else { _visitables.get("nodeStatuses").add(index, builder); nodeStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToNodeStatuses(int index,NodeStatus item) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    NodeStatusBuilder builder = new NodeStatusBuilder(item);
    if (index < 0 || index >= nodeStatuses.size()) { _visitables.get("nodeStatuses").add(builder); nodeStatuses.add(builder); } else { _visitables.get("nodeStatuses").set(index, builder); nodeStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... items) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").add(builder);this.nodeStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToNodeStatuses(Collection<NodeStatus> items) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").add(builder);this.nodeStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... items) {
    if (this.nodeStatuses == null) return (A)this;
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").remove(builder); this.nodeStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNodeStatuses(Collection<NodeStatus> items) {
    if (this.nodeStatuses == null) return (A)this;
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").remove(builder); this.nodeStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNodeStatuses(Predicate<NodeStatusBuilder> predicate) {
    if (nodeStatuses == null) return (A) this;
    final Iterator<NodeStatusBuilder> each = nodeStatuses.iterator();
    final List visitables = _visitables.get("nodeStatuses");
    while (each.hasNext()) {
      NodeStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeStatus> buildNodeStatuses() {
    return nodeStatuses != null ? build(nodeStatuses) : null;
  }
  
  public NodeStatus buildNodeStatus(int index) {
    return this.nodeStatuses.get(index).build();
  }
  
  public NodeStatus buildFirstNodeStatus() {
    return this.nodeStatuses.get(0).build();
  }
  
  public NodeStatus buildLastNodeStatus() {
    return this.nodeStatuses.get(nodeStatuses.size() - 1).build();
  }
  
  public NodeStatus buildMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
    for (NodeStatusBuilder item: nodeStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
    for (NodeStatusBuilder item: nodeStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withNodeStatuses(List<NodeStatus> nodeStatuses) {
    if (this.nodeStatuses != null) { _visitables.get("nodeStatuses").clear();}
    if (nodeStatuses != null) {this.nodeStatuses = new ArrayList(); for (NodeStatus item : nodeStatuses){this.addToNodeStatuses(item);}} else { this.nodeStatuses = null;} return (A) this;
  }
  
  public A withNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... nodeStatuses) {
    if (this.nodeStatuses != null) {this.nodeStatuses.clear(); _visitables.remove("nodeStatuses"); }
    if (nodeStatuses != null) {for (NodeStatus item :nodeStatuses){ this.addToNodeStatuses(item);}} return (A) this;
  }
  
  public boolean hasNodeStatuses() {
    return nodeStatuses != null && !nodeStatuses.isEmpty();
  }
  
  public NodeStatusesNested<A> addNewNodeStatus() {
    return new NodeStatusesNested(-1, null);
  }
  
  public NodeStatusesNested<A> addNewNodeStatusLike(NodeStatus item) {
    return new NodeStatusesNested(-1, item);
  }
  
  public NodeStatusesNested<A> setNewNodeStatusLike(int index,NodeStatus item) {
    return new NodeStatusesNested(index, item);
  }
  
  public NodeStatusesNested<A> editNodeStatus(int index) {
    if (nodeStatuses.size() <= index) throw new RuntimeException("Can't edit nodeStatuses. Index exceeds size.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public NodeStatusesNested<A> editFirstNodeStatus() {
    if (nodeStatuses.size() == 0) throw new RuntimeException("Can't edit first nodeStatuses. The list is empty.");
    return setNewNodeStatusLike(0, buildNodeStatus(0));
  }
  
  public NodeStatusesNested<A> editLastNodeStatus() {
    int index = nodeStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nodeStatuses. The list is empty.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public NodeStatusesNested<A> editMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nodeStatuses.size();i++) { 
    if (predicate.test(nodeStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nodeStatuses. No match found.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  
  public boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeControllerManagerStatusFluent that = (KubeControllerManagerStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(generations, that.generations)) return false;
  
    if (!java.util.Objects.equals(latestAvailableRevision, that.latestAvailableRevision)) return false;
  
    if (!java.util.Objects.equals(latestAvailableRevisionReason, that.latestAvailableRevisionReason)) return false;
  
    if (!java.util.Objects.equals(nodeStatuses, that.nodeStatuses)) return false;
  
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
  
    if (!java.util.Objects.equals(readyReplicas, that.readyReplicas)) return false;
  
    if (!java.util.Objects.equals(version, that.version)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  latestAvailableRevision,  latestAvailableRevisionReason,  nodeStatuses,  observedGeneration,  readyReplicas,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (latestAvailableRevision != null) { sb.append("latestAvailableRevision:"); sb.append(latestAvailableRevision + ","); }
    if (latestAvailableRevisionReason != null) { sb.append("latestAvailableRevisionReason:"); sb.append(latestAvailableRevisionReason + ","); }
    if (nodeStatuses != null && !nodeStatuses.isEmpty()) { sb.append("nodeStatuses:"); sb.append(nodeStatuses + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends OperatorConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,OperatorCondition item) {
      this.index = index;
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) KubeControllerManagerStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class GenerationsNested<N> extends GenerationStatusFluent<GenerationsNested<N>> implements Nested<N>{
    GenerationsNested(int index,GenerationStatus item) {
      this.index = index;
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) KubeControllerManagerStatusFluent.this.setToGenerations(index,builder.build());
    }
    
    public N endGeneration() {
      return and();
    }
    
  
  }
  public class NodeStatusesNested<N> extends NodeStatusFluent<NodeStatusesNested<N>> implements Nested<N>{
    NodeStatusesNested(int index,NodeStatus item) {
      this.index = index;
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) KubeControllerManagerStatusFluent.this.setToNodeStatuses(index,builder.build());
    }
    
    public N endNodeStatus() {
      return and();
    }
    
  
  }

}