package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OVNKubernetesConfigFluent<A extends OVNKubernetesConfigFluent<A>> extends BaseFluent<A>{
  public OVNKubernetesConfigFluent() {
  }
  
  public OVNKubernetesConfigFluent(OVNKubernetesConfig instance) {
    this.copyInstance(instance);
  }
  private EgressIPConfigBuilder egressIPConfig;
  private GatewayConfigBuilder gatewayConfig;
  private Integer genevePort;
  private HybridOverlayConfigBuilder hybridOverlayConfig;
  private IPsecConfigBuilder ipsecConfig;
  private Integer mtu;
  private PolicyAuditConfigBuilder policyAuditConfig;
  private String v4InternalSubnet;
  private String v6InternalSubnet;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OVNKubernetesConfig instance) {
    instance = (instance != null ? instance : new OVNKubernetesConfig());
  
    if (instance != null) {
        this.withEgressIPConfig(instance.getEgressIPConfig());
        this.withGatewayConfig(instance.getGatewayConfig());
        this.withGenevePort(instance.getGenevePort());
        this.withHybridOverlayConfig(instance.getHybridOverlayConfig());
        this.withIpsecConfig(instance.getIpsecConfig());
        this.withMtu(instance.getMtu());
        this.withPolicyAuditConfig(instance.getPolicyAuditConfig());
        this.withV4InternalSubnet(instance.getV4InternalSubnet());
        this.withV6InternalSubnet(instance.getV6InternalSubnet());
        this.withEgressIPConfig(instance.getEgressIPConfig());
        this.withGatewayConfig(instance.getGatewayConfig());
        this.withGenevePort(instance.getGenevePort());
        this.withHybridOverlayConfig(instance.getHybridOverlayConfig());
        this.withIpsecConfig(instance.getIpsecConfig());
        this.withMtu(instance.getMtu());
        this.withPolicyAuditConfig(instance.getPolicyAuditConfig());
        this.withV4InternalSubnet(instance.getV4InternalSubnet());
        this.withV6InternalSubnet(instance.getV6InternalSubnet());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public EgressIPConfig buildEgressIPConfig() {
    return this.egressIPConfig!=null ?this.egressIPConfig.build():null;
  }
  
  public A withEgressIPConfig(EgressIPConfig egressIPConfig) {
    _visitables.get("egressIPConfig").remove(this.egressIPConfig);
    if (egressIPConfig!=null){ this.egressIPConfig= new EgressIPConfigBuilder(egressIPConfig); _visitables.get("egressIPConfig").add(this.egressIPConfig);} else { this.egressIPConfig = null; _visitables.get("egressIPConfig").remove(this.egressIPConfig); } return (A) this;
  }
  
  public boolean hasEgressIPConfig() {
    return this.egressIPConfig != null;
  }
  
  public A withNewEgressIPConfig(Integer reachabilityTotalTimeoutSeconds) {
    return (A)withEgressIPConfig(new EgressIPConfig(reachabilityTotalTimeoutSeconds));
  }
  
  public EgressIPConfigNested<A> withNewEgressIPConfig() {
    return new EgressIPConfigNested(null);
  }
  
  public EgressIPConfigNested<A> withNewEgressIPConfigLike(EgressIPConfig item) {
    return new EgressIPConfigNested(item);
  }
  
  public EgressIPConfigNested<A> editEgressIPConfig() {
    return withNewEgressIPConfigLike(java.util.Optional.ofNullable(buildEgressIPConfig()).orElse(null));
  }
  
  public EgressIPConfigNested<A> editOrNewEgressIPConfig() {
    return withNewEgressIPConfigLike(java.util.Optional.ofNullable(buildEgressIPConfig()).orElse(new EgressIPConfigBuilder().build()));
  }
  
  public EgressIPConfigNested<A> editOrNewEgressIPConfigLike(EgressIPConfig item) {
    return withNewEgressIPConfigLike(java.util.Optional.ofNullable(buildEgressIPConfig()).orElse(item));
  }
  
  public GatewayConfig buildGatewayConfig() {
    return this.gatewayConfig!=null ?this.gatewayConfig.build():null;
  }
  
  public A withGatewayConfig(GatewayConfig gatewayConfig) {
    _visitables.get("gatewayConfig").remove(this.gatewayConfig);
    if (gatewayConfig!=null){ this.gatewayConfig= new GatewayConfigBuilder(gatewayConfig); _visitables.get("gatewayConfig").add(this.gatewayConfig);} else { this.gatewayConfig = null; _visitables.get("gatewayConfig").remove(this.gatewayConfig); } return (A) this;
  }
  
  public boolean hasGatewayConfig() {
    return this.gatewayConfig != null;
  }
  
  public A withNewGatewayConfig(String ipForwarding,Boolean routingViaHost) {
    return (A)withGatewayConfig(new GatewayConfig(ipForwarding, routingViaHost));
  }
  
  public GatewayConfigNested<A> withNewGatewayConfig() {
    return new GatewayConfigNested(null);
  }
  
  public GatewayConfigNested<A> withNewGatewayConfigLike(GatewayConfig item) {
    return new GatewayConfigNested(item);
  }
  
  public GatewayConfigNested<A> editGatewayConfig() {
    return withNewGatewayConfigLike(java.util.Optional.ofNullable(buildGatewayConfig()).orElse(null));
  }
  
  public GatewayConfigNested<A> editOrNewGatewayConfig() {
    return withNewGatewayConfigLike(java.util.Optional.ofNullable(buildGatewayConfig()).orElse(new GatewayConfigBuilder().build()));
  }
  
  public GatewayConfigNested<A> editOrNewGatewayConfigLike(GatewayConfig item) {
    return withNewGatewayConfigLike(java.util.Optional.ofNullable(buildGatewayConfig()).orElse(item));
  }
  
  public Integer getGenevePort() {
    return this.genevePort;
  }
  
  public A withGenevePort(Integer genevePort) {
    this.genevePort=genevePort; return (A) this;
  }
  
  public boolean hasGenevePort() {
    return this.genevePort != null;
  }
  
  public HybridOverlayConfig buildHybridOverlayConfig() {
    return this.hybridOverlayConfig!=null ?this.hybridOverlayConfig.build():null;
  }
  
  public A withHybridOverlayConfig(HybridOverlayConfig hybridOverlayConfig) {
    _visitables.get("hybridOverlayConfig").remove(this.hybridOverlayConfig);
    if (hybridOverlayConfig!=null){ this.hybridOverlayConfig= new HybridOverlayConfigBuilder(hybridOverlayConfig); _visitables.get("hybridOverlayConfig").add(this.hybridOverlayConfig);} else { this.hybridOverlayConfig = null; _visitables.get("hybridOverlayConfig").remove(this.hybridOverlayConfig); } return (A) this;
  }
  
  public boolean hasHybridOverlayConfig() {
    return this.hybridOverlayConfig != null;
  }
  
  public HybridOverlayConfigNested<A> withNewHybridOverlayConfig() {
    return new HybridOverlayConfigNested(null);
  }
  
  public HybridOverlayConfigNested<A> withNewHybridOverlayConfigLike(HybridOverlayConfig item) {
    return new HybridOverlayConfigNested(item);
  }
  
  public HybridOverlayConfigNested<A> editHybridOverlayConfig() {
    return withNewHybridOverlayConfigLike(java.util.Optional.ofNullable(buildHybridOverlayConfig()).orElse(null));
  }
  
  public HybridOverlayConfigNested<A> editOrNewHybridOverlayConfig() {
    return withNewHybridOverlayConfigLike(java.util.Optional.ofNullable(buildHybridOverlayConfig()).orElse(new HybridOverlayConfigBuilder().build()));
  }
  
  public HybridOverlayConfigNested<A> editOrNewHybridOverlayConfigLike(HybridOverlayConfig item) {
    return withNewHybridOverlayConfigLike(java.util.Optional.ofNullable(buildHybridOverlayConfig()).orElse(item));
  }
  
  public IPsecConfig buildIpsecConfig() {
    return this.ipsecConfig!=null ?this.ipsecConfig.build():null;
  }
  
  public A withIpsecConfig(IPsecConfig ipsecConfig) {
    _visitables.get("ipsecConfig").remove(this.ipsecConfig);
    if (ipsecConfig!=null){ this.ipsecConfig= new IPsecConfigBuilder(ipsecConfig); _visitables.get("ipsecConfig").add(this.ipsecConfig);} else { this.ipsecConfig = null; _visitables.get("ipsecConfig").remove(this.ipsecConfig); } return (A) this;
  }
  
  public boolean hasIpsecConfig() {
    return this.ipsecConfig != null;
  }
  
  public IpsecConfigNested<A> withNewIpsecConfig() {
    return new IpsecConfigNested(null);
  }
  
  public IpsecConfigNested<A> withNewIpsecConfigLike(IPsecConfig item) {
    return new IpsecConfigNested(item);
  }
  
  public IpsecConfigNested<A> editIpsecConfig() {
    return withNewIpsecConfigLike(java.util.Optional.ofNullable(buildIpsecConfig()).orElse(null));
  }
  
  public IpsecConfigNested<A> editOrNewIpsecConfig() {
    return withNewIpsecConfigLike(java.util.Optional.ofNullable(buildIpsecConfig()).orElse(new IPsecConfigBuilder().build()));
  }
  
  public IpsecConfigNested<A> editOrNewIpsecConfigLike(IPsecConfig item) {
    return withNewIpsecConfigLike(java.util.Optional.ofNullable(buildIpsecConfig()).orElse(item));
  }
  
  public Integer getMtu() {
    return this.mtu;
  }
  
  public A withMtu(Integer mtu) {
    this.mtu=mtu; return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public PolicyAuditConfig buildPolicyAuditConfig() {
    return this.policyAuditConfig!=null ?this.policyAuditConfig.build():null;
  }
  
  public A withPolicyAuditConfig(PolicyAuditConfig policyAuditConfig) {
    _visitables.get("policyAuditConfig").remove(this.policyAuditConfig);
    if (policyAuditConfig!=null){ this.policyAuditConfig= new PolicyAuditConfigBuilder(policyAuditConfig); _visitables.get("policyAuditConfig").add(this.policyAuditConfig);} else { this.policyAuditConfig = null; _visitables.get("policyAuditConfig").remove(this.policyAuditConfig); } return (A) this;
  }
  
  public boolean hasPolicyAuditConfig() {
    return this.policyAuditConfig != null;
  }
  
  public A withNewPolicyAuditConfig(String destination,Integer maxFileSize,Integer maxLogFiles,Integer rateLimit,String syslogFacility) {
    return (A)withPolicyAuditConfig(new PolicyAuditConfig(destination, maxFileSize, maxLogFiles, rateLimit, syslogFacility));
  }
  
  public PolicyAuditConfigNested<A> withNewPolicyAuditConfig() {
    return new PolicyAuditConfigNested(null);
  }
  
  public PolicyAuditConfigNested<A> withNewPolicyAuditConfigLike(PolicyAuditConfig item) {
    return new PolicyAuditConfigNested(item);
  }
  
  public PolicyAuditConfigNested<A> editPolicyAuditConfig() {
    return withNewPolicyAuditConfigLike(java.util.Optional.ofNullable(buildPolicyAuditConfig()).orElse(null));
  }
  
  public PolicyAuditConfigNested<A> editOrNewPolicyAuditConfig() {
    return withNewPolicyAuditConfigLike(java.util.Optional.ofNullable(buildPolicyAuditConfig()).orElse(new PolicyAuditConfigBuilder().build()));
  }
  
  public PolicyAuditConfigNested<A> editOrNewPolicyAuditConfigLike(PolicyAuditConfig item) {
    return withNewPolicyAuditConfigLike(java.util.Optional.ofNullable(buildPolicyAuditConfig()).orElse(item));
  }
  
  public String getV4InternalSubnet() {
    return this.v4InternalSubnet;
  }
  
  public A withV4InternalSubnet(String v4InternalSubnet) {
    this.v4InternalSubnet=v4InternalSubnet; return (A) this;
  }
  
  public boolean hasV4InternalSubnet() {
    return this.v4InternalSubnet != null;
  }
  
  public String getV6InternalSubnet() {
    return this.v6InternalSubnet;
  }
  
  public A withV6InternalSubnet(String v6InternalSubnet) {
    this.v6InternalSubnet=v6InternalSubnet; return (A) this;
  }
  
  public boolean hasV6InternalSubnet() {
    return this.v6InternalSubnet != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OVNKubernetesConfigFluent that = (OVNKubernetesConfigFluent) o;
    if (!java.util.Objects.equals(egressIPConfig, that.egressIPConfig)) return false;
  
    if (!java.util.Objects.equals(gatewayConfig, that.gatewayConfig)) return false;
  
    if (!java.util.Objects.equals(genevePort, that.genevePort)) return false;
  
    if (!java.util.Objects.equals(hybridOverlayConfig, that.hybridOverlayConfig)) return false;
  
    if (!java.util.Objects.equals(ipsecConfig, that.ipsecConfig)) return false;
  
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
  
    if (!java.util.Objects.equals(policyAuditConfig, that.policyAuditConfig)) return false;
  
    if (!java.util.Objects.equals(v4InternalSubnet, that.v4InternalSubnet)) return false;
  
    if (!java.util.Objects.equals(v6InternalSubnet, that.v6InternalSubnet)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(egressIPConfig,  gatewayConfig,  genevePort,  hybridOverlayConfig,  ipsecConfig,  mtu,  policyAuditConfig,  v4InternalSubnet,  v6InternalSubnet,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egressIPConfig != null) { sb.append("egressIPConfig:"); sb.append(egressIPConfig + ","); }
    if (gatewayConfig != null) { sb.append("gatewayConfig:"); sb.append(gatewayConfig + ","); }
    if (genevePort != null) { sb.append("genevePort:"); sb.append(genevePort + ","); }
    if (hybridOverlayConfig != null) { sb.append("hybridOverlayConfig:"); sb.append(hybridOverlayConfig + ","); }
    if (ipsecConfig != null) { sb.append("ipsecConfig:"); sb.append(ipsecConfig + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (policyAuditConfig != null) { sb.append("policyAuditConfig:"); sb.append(policyAuditConfig + ","); }
    if (v4InternalSubnet != null) { sb.append("v4InternalSubnet:"); sb.append(v4InternalSubnet + ","); }
    if (v6InternalSubnet != null) { sb.append("v6InternalSubnet:"); sb.append(v6InternalSubnet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EgressIPConfigNested<N> extends EgressIPConfigFluent<EgressIPConfigNested<N>> implements Nested<N>{
    EgressIPConfigNested(EgressIPConfig item) {
      this.builder = new EgressIPConfigBuilder(this, item);
    }
    EgressIPConfigBuilder builder;
    
    public N and() {
      return (N) OVNKubernetesConfigFluent.this.withEgressIPConfig(builder.build());
    }
    
    public N endEgressIPConfig() {
      return and();
    }
    
  
  }
  public class GatewayConfigNested<N> extends GatewayConfigFluent<GatewayConfigNested<N>> implements Nested<N>{
    GatewayConfigNested(GatewayConfig item) {
      this.builder = new GatewayConfigBuilder(this, item);
    }
    GatewayConfigBuilder builder;
    
    public N and() {
      return (N) OVNKubernetesConfigFluent.this.withGatewayConfig(builder.build());
    }
    
    public N endGatewayConfig() {
      return and();
    }
    
  
  }
  public class HybridOverlayConfigNested<N> extends HybridOverlayConfigFluent<HybridOverlayConfigNested<N>> implements Nested<N>{
    HybridOverlayConfigNested(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigBuilder builder;
    
    public N and() {
      return (N) OVNKubernetesConfigFluent.this.withHybridOverlayConfig(builder.build());
    }
    
    public N endHybridOverlayConfig() {
      return and();
    }
    
  
  }
  public class IpsecConfigNested<N> extends IPsecConfigFluent<IpsecConfigNested<N>> implements Nested<N>{
    IpsecConfigNested(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigBuilder builder;
    
    public N and() {
      return (N) OVNKubernetesConfigFluent.this.withIpsecConfig(builder.build());
    }
    
    public N endIpsecConfig() {
      return and();
    }
    
  
  }
  public class PolicyAuditConfigNested<N> extends PolicyAuditConfigFluent<PolicyAuditConfigNested<N>> implements Nested<N>{
    PolicyAuditConfigNested(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigBuilder builder;
    
    public N and() {
      return (N) OVNKubernetesConfigFluent.this.withPolicyAuditConfig(builder.build());
    }
    
    public N endPolicyAuditConfig() {
      return and();
    }
    
  
  }

}