package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SFlowConfigFluent<A extends SFlowConfigFluent<A>> extends BaseFluent<A>{
  public SFlowConfigFluent() {
  }
  
  public SFlowConfigFluent(SFlowConfig instance) {
    this.copyInstance(instance);
  }
  private List<String> collectors = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SFlowConfig instance) {
    instance = (instance != null ? instance : new SFlowConfig());
  
    if (instance != null) {
        this.withCollectors(instance.getCollectors());
        this.withCollectors(instance.getCollectors());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToCollectors(int index,String item) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    this.collectors.add(index, item);
    return (A)this;
  }
  
  public A setToCollectors(int index,String item) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    this.collectors.set(index, item); return (A)this;
  }
  
  public A addToCollectors(java.lang.String... items) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    for (String item : items) {this.collectors.add(item);} return (A)this;
  }
  
  public A addAllToCollectors(Collection<String> items) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    for (String item : items) {this.collectors.add(item);} return (A)this;
  }
  
  public A removeFromCollectors(java.lang.String... items) {
    if (this.collectors == null) return (A)this;
    for (String item : items) { this.collectors.remove(item);} return (A)this;
  }
  
  public A removeAllFromCollectors(Collection<String> items) {
    if (this.collectors == null) return (A)this;
    for (String item : items) { this.collectors.remove(item);} return (A)this;
  }
  
  public List<String> getCollectors() {
    return this.collectors;
  }
  
  public String getCollector(int index) {
    return this.collectors.get(index);
  }
  
  public String getFirstCollector() {
    return this.collectors.get(0);
  }
  
  public String getLastCollector() {
    return this.collectors.get(collectors.size() - 1);
  }
  
  public String getMatchingCollector(Predicate<String> predicate) {
    for (String item: collectors) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingCollector(Predicate<String> predicate) {
    for (String item: collectors) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withCollectors(List<String> collectors) {
    if (collectors != null) {this.collectors = new ArrayList(); for (String item : collectors){this.addToCollectors(item);}} else { this.collectors = null;} return (A) this;
  }
  
  public A withCollectors(java.lang.String... collectors) {
    if (this.collectors != null) {this.collectors.clear(); _visitables.remove("collectors"); }
    if (collectors != null) {for (String item :collectors){ this.addToCollectors(item);}} return (A) this;
  }
  
  public boolean hasCollectors() {
    return collectors != null && !collectors.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SFlowConfigFluent that = (SFlowConfigFluent) o;
    if (!java.util.Objects.equals(collectors, that.collectors)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(collectors,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (collectors != null && !collectors.isEmpty()) { sb.append("collectors:"); sb.append(collectors + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}