/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategory;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryBuilder;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryFluent;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCustomization;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogTypes;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogTypesBuilder;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogTypesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeveloperConsoleCatalogCustomizationFluent<A extends DeveloperConsoleCatalogCustomizationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DeveloperConsoleCatalogCategoryBuilder> categories = new ArrayList();
    private DeveloperConsoleCatalogTypesBuilder types;
    private Map<String, Object> additionalProperties;

    public DeveloperConsoleCatalogCustomizationFluent() {
    }

    public DeveloperConsoleCatalogCustomizationFluent(DeveloperConsoleCatalogCustomization instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeveloperConsoleCatalogCustomization instance) {
        DeveloperConsoleCatalogCustomization developerConsoleCatalogCustomization = instance = instance != null ? instance : new DeveloperConsoleCatalogCustomization();
        if (instance != null) {
            this.withCategories(instance.getCategories());
            this.withTypes(instance.getTypes());
            this.withCategories(instance.getCategories());
            this.withTypes(instance.getTypes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCategories(int index, DeveloperConsoleCatalogCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
        if (index < 0 || index >= this.categories.size()) {
            this._visitables.get((Object)"categories").add(builder);
            this.categories.add(builder);
        } else {
            this._visitables.get((Object)"categories").add(index, builder);
            this.categories.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCategories(int index, DeveloperConsoleCatalogCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
        if (index < 0 || index >= this.categories.size()) {
            this._visitables.get((Object)"categories").add(builder);
            this.categories.add(builder);
        } else {
            this._visitables.get((Object)"categories").set(index, builder);
            this.categories.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCategories(DeveloperConsoleCatalogCategory ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        for (DeveloperConsoleCatalogCategory item : items) {
            DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
            this._visitables.get((Object)"categories").add(builder);
            this.categories.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCategories(Collection<DeveloperConsoleCatalogCategory> items) {
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        for (DeveloperConsoleCatalogCategory item : items) {
            DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
            this._visitables.get((Object)"categories").add(builder);
            this.categories.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCategories(DeveloperConsoleCatalogCategory ... items) {
        if (this.categories == null) {
            return (A)((Object)this);
        }
        for (DeveloperConsoleCatalogCategory item : items) {
            DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
            this._visitables.get((Object)"categories").remove((Object)builder);
            this.categories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCategories(Collection<DeveloperConsoleCatalogCategory> items) {
        if (this.categories == null) {
            return (A)((Object)this);
        }
        for (DeveloperConsoleCatalogCategory item : items) {
            DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
            this._visitables.get((Object)"categories").remove((Object)builder);
            this.categories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCategories(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
        if (this.categories == null) {
            return (A)((Object)this);
        }
        Iterator<DeveloperConsoleCatalogCategoryBuilder> each = this.categories.iterator();
        List visitables = this._visitables.get((Object)"categories");
        while (each.hasNext()) {
            DeveloperConsoleCatalogCategoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DeveloperConsoleCatalogCategory> buildCategories() {
        return this.categories != null ? DeveloperConsoleCatalogCustomizationFluent.build(this.categories) : null;
    }

    public DeveloperConsoleCatalogCategory buildCategory(int index) {
        return this.categories.get(index).build();
    }

    public DeveloperConsoleCatalogCategory buildFirstCategory() {
        return this.categories.get(0).build();
    }

    public DeveloperConsoleCatalogCategory buildLastCategory() {
        return this.categories.get(this.categories.size() - 1).build();
    }

    public DeveloperConsoleCatalogCategory buildMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
        for (DeveloperConsoleCatalogCategoryBuilder item : this.categories) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
        for (DeveloperConsoleCatalogCategoryBuilder item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCategories(List<DeveloperConsoleCatalogCategory> categories) {
        if (this.categories != null) {
            this._visitables.get((Object)"categories").clear();
        }
        if (categories != null) {
            this.categories = new ArrayList();
            for (DeveloperConsoleCatalogCategory item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)((Object)this);
    }

    public A withCategories(DeveloperConsoleCatalogCategory ... categories) {
        if (this.categories != null) {
            this.categories.clear();
            this._visitables.remove((Object)"categories");
        }
        if (categories != null) {
            for (DeveloperConsoleCatalogCategory item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public CategoriesNested<A> addNewCategory() {
        return new CategoriesNested(-1, null);
    }

    public CategoriesNested<A> addNewCategoryLike(DeveloperConsoleCatalogCategory item) {
        return new CategoriesNested(-1, item);
    }

    public CategoriesNested<A> setNewCategoryLike(int index, DeveloperConsoleCatalogCategory item) {
        return new CategoriesNested(index, item);
    }

    public CategoriesNested<A> editCategory(int index) {
        if (this.categories.size() <= index) {
            throw new RuntimeException("Can't edit categories. Index exceeds size.");
        }
        return this.setNewCategoryLike(index, this.buildCategory(index));
    }

    public CategoriesNested<A> editFirstCategory() {
        if (this.categories.size() == 0) {
            throw new RuntimeException("Can't edit first categories. The list is empty.");
        }
        return this.setNewCategoryLike(0, this.buildCategory(0));
    }

    public CategoriesNested<A> editLastCategory() {
        int index = this.categories.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last categories. The list is empty.");
        }
        return this.setNewCategoryLike(index, this.buildCategory(index));
    }

    public CategoriesNested<A> editMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!predicate.test(this.categories.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching categories. No match found.");
        }
        return this.setNewCategoryLike(index, this.buildCategory(index));
    }

    public DeveloperConsoleCatalogTypes buildTypes() {
        return this.types != null ? this.types.build() : null;
    }

    public A withTypes(DeveloperConsoleCatalogTypes types) {
        this._visitables.get((Object)"types").remove((Object)this.types);
        if (types != null) {
            this.types = new DeveloperConsoleCatalogTypesBuilder(types);
            this._visitables.get((Object)"types").add(this.types);
        } else {
            this.types = null;
            this._visitables.get((Object)"types").remove((Object)this.types);
        }
        return (A)((Object)this);
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    public TypesNested<A> withNewTypes() {
        return new TypesNested(null);
    }

    public TypesNested<A> withNewTypesLike(DeveloperConsoleCatalogTypes item) {
        return new TypesNested(item);
    }

    public TypesNested<A> editTypes() {
        return this.withNewTypesLike(Optional.ofNullable(this.buildTypes()).orElse(null));
    }

    public TypesNested<A> editOrNewTypes() {
        return this.withNewTypesLike(Optional.ofNullable(this.buildTypes()).orElse(new DeveloperConsoleCatalogTypesBuilder().build()));
    }

    public TypesNested<A> editOrNewTypesLike(DeveloperConsoleCatalogTypes item) {
        return this.withNewTypesLike(Optional.ofNullable(this.buildTypes()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeveloperConsoleCatalogCustomizationFluent that = (DeveloperConsoleCatalogCustomizationFluent)((Object)o);
        if (!Objects.equals(this.categories, that.categories)) {
            return false;
        }
        if (!Objects.equals((Object)this.types, (Object)that.types)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.categories, this.types, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(this.categories + ",");
        }
        if (this.types != null) {
            sb.append("types:");
            sb.append((Object)((Object)this.types) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TypesNested<N>
    extends DeveloperConsoleCatalogTypesFluent<TypesNested<N>>
    implements Nested<N> {
        DeveloperConsoleCatalogTypesBuilder builder;

        TypesNested(DeveloperConsoleCatalogTypes item) {
            this.builder = new DeveloperConsoleCatalogTypesBuilder(this, item);
        }

        public N and() {
            return (N)DeveloperConsoleCatalogCustomizationFluent.this.withTypes(this.builder.build());
        }

        public N endTypes() {
            return this.and();
        }
    }

    public class CategoriesNested<N>
    extends DeveloperConsoleCatalogCategoryFluent<CategoriesNested<N>>
    implements Nested<N> {
        DeveloperConsoleCatalogCategoryBuilder builder;
        int index;

        CategoriesNested(int index, DeveloperConsoleCatalogCategory item) {
            this.index = index;
            this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
        }

        public N and() {
            return (N)DeveloperConsoleCatalogCustomizationFluent.this.setToCategories(this.index, this.builder.build());
        }

        public N endCategory() {
            return this.and();
        }
    }
}

