package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExportNetworkFlowsFluent<A extends ExportNetworkFlowsFluent<A>> extends BaseFluent<A>{
  public ExportNetworkFlowsFluent() {
  }
  
  public ExportNetworkFlowsFluent(ExportNetworkFlows instance) {
    this.copyInstance(instance);
  }
  private IPFIXConfigBuilder ipfix;
  private NetFlowConfigBuilder netFlow;
  private SFlowConfigBuilder sFlow;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ExportNetworkFlows instance) {
    instance = (instance != null ? instance : new ExportNetworkFlows());
    if (instance != null) {
          this.withIpfix(instance.getIpfix());
          this.withNetFlow(instance.getNetFlow());
          this.withSFlow(instance.getSFlow());
          this.withIpfix(instance.getIpfix());
          this.withNetFlow(instance.getNetFlow());
          this.withSFlow(instance.getSFlow());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IPFIXConfig buildIpfix() {
    return this.ipfix != null ? this.ipfix.build() : null;
  }
  
  public A withIpfix(IPFIXConfig ipfix) {
    this._visitables.remove(this.ipfix);
    if (ipfix != null) {
        this.ipfix = new IPFIXConfigBuilder(ipfix);
        this._visitables.get("ipfix").add(this.ipfix);
    } else {
        this.ipfix = null;
        this._visitables.get("ipfix").remove(this.ipfix);
    }
    return (A) this;
  }
  
  public boolean hasIpfix() {
    return this.ipfix != null;
  }
  
  public IpfixNested<A> withNewIpfix() {
    return new IpfixNested(null);
  }
  
  public IpfixNested<A> withNewIpfixLike(IPFIXConfig item) {
    return new IpfixNested(item);
  }
  
  public IpfixNested<A> editIpfix() {
    return withNewIpfixLike(java.util.Optional.ofNullable(buildIpfix()).orElse(null));
  }
  
  public IpfixNested<A> editOrNewIpfix() {
    return withNewIpfixLike(java.util.Optional.ofNullable(buildIpfix()).orElse(new IPFIXConfigBuilder().build()));
  }
  
  public IpfixNested<A> editOrNewIpfixLike(IPFIXConfig item) {
    return withNewIpfixLike(java.util.Optional.ofNullable(buildIpfix()).orElse(item));
  }
  
  public NetFlowConfig buildNetFlow() {
    return this.netFlow != null ? this.netFlow.build() : null;
  }
  
  public A withNetFlow(NetFlowConfig netFlow) {
    this._visitables.remove(this.netFlow);
    if (netFlow != null) {
        this.netFlow = new NetFlowConfigBuilder(netFlow);
        this._visitables.get("netFlow").add(this.netFlow);
    } else {
        this.netFlow = null;
        this._visitables.get("netFlow").remove(this.netFlow);
    }
    return (A) this;
  }
  
  public boolean hasNetFlow() {
    return this.netFlow != null;
  }
  
  public NetFlowNested<A> withNewNetFlow() {
    return new NetFlowNested(null);
  }
  
  public NetFlowNested<A> withNewNetFlowLike(NetFlowConfig item) {
    return new NetFlowNested(item);
  }
  
  public NetFlowNested<A> editNetFlow() {
    return withNewNetFlowLike(java.util.Optional.ofNullable(buildNetFlow()).orElse(null));
  }
  
  public NetFlowNested<A> editOrNewNetFlow() {
    return withNewNetFlowLike(java.util.Optional.ofNullable(buildNetFlow()).orElse(new NetFlowConfigBuilder().build()));
  }
  
  public NetFlowNested<A> editOrNewNetFlowLike(NetFlowConfig item) {
    return withNewNetFlowLike(java.util.Optional.ofNullable(buildNetFlow()).orElse(item));
  }
  
  public SFlowConfig buildSFlow() {
    return this.sFlow != null ? this.sFlow.build() : null;
  }
  
  public A withSFlow(SFlowConfig sFlow) {
    this._visitables.remove(this.sFlow);
    if (sFlow != null) {
        this.sFlow = new SFlowConfigBuilder(sFlow);
        this._visitables.get("sFlow").add(this.sFlow);
    } else {
        this.sFlow = null;
        this._visitables.get("sFlow").remove(this.sFlow);
    }
    return (A) this;
  }
  
  public boolean hasSFlow() {
    return this.sFlow != null;
  }
  
  public SFlowNested<A> withNewSFlow() {
    return new SFlowNested(null);
  }
  
  public SFlowNested<A> withNewSFlowLike(SFlowConfig item) {
    return new SFlowNested(item);
  }
  
  public SFlowNested<A> editSFlow() {
    return withNewSFlowLike(java.util.Optional.ofNullable(buildSFlow()).orElse(null));
  }
  
  public SFlowNested<A> editOrNewSFlow() {
    return withNewSFlowLike(java.util.Optional.ofNullable(buildSFlow()).orElse(new SFlowConfigBuilder().build()));
  }
  
  public SFlowNested<A> editOrNewSFlowLike(SFlowConfig item) {
    return withNewSFlowLike(java.util.Optional.ofNullable(buildSFlow()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExportNetworkFlowsFluent that = (ExportNetworkFlowsFluent) o;
    if (!java.util.Objects.equals(ipfix, that.ipfix)) return false;
    if (!java.util.Objects.equals(netFlow, that.netFlow)) return false;
    if (!java.util.Objects.equals(sFlow, that.sFlow)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ipfix,  netFlow,  sFlow,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipfix != null) { sb.append("ipfix:"); sb.append(ipfix + ","); }
    if (netFlow != null) { sb.append("netFlow:"); sb.append(netFlow + ","); }
    if (sFlow != null) { sb.append("sFlow:"); sb.append(sFlow + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IpfixNested<N> extends IPFIXConfigFluent<IpfixNested<N>> implements Nested<N>{
    IpfixNested(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigBuilder builder;
    
    public N and() {
      return (N) ExportNetworkFlowsFluent.this.withIpfix(builder.build());
    }
    
    public N endIpfix() {
      return and();
    }
    
  
  }
  public class NetFlowNested<N> extends NetFlowConfigFluent<NetFlowNested<N>> implements Nested<N>{
    NetFlowNested(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigBuilder builder;
    
    public N and() {
      return (N) ExportNetworkFlowsFluent.this.withNetFlow(builder.build());
    }
    
    public N endNetFlow() {
      return and();
    }
    
  
  }
  public class SFlowNested<N> extends SFlowConfigFluent<SFlowNested<N>> implements Nested<N>{
    SFlowNested(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigBuilder builder;
    
    public N and() {
      return (N) ExportNetworkFlowsFluent.this.withSFlow(builder.build());
    }
    
    public N endSFlow() {
      return and();
    }
    
  
  }

}