package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressControllerTuningOptionsFluent<A extends IngressControllerTuningOptionsFluent<A>> extends BaseFluent<A>{
  public IngressControllerTuningOptionsFluent() {
  }
  
  public IngressControllerTuningOptionsFluent(IngressControllerTuningOptions instance) {
    this.copyInstance(instance);
  }
  private Duration clientFinTimeout;
  private Duration clientTimeout;
  private Integer headerBufferBytes;
  private Integer headerBufferMaxRewriteBytes;
  private Duration healthCheckInterval;
  private Integer maxConnections;
  private Duration reloadInterval;
  private Duration serverFinTimeout;
  private Duration serverTimeout;
  private Integer threadCount;
  private Duration tlsInspectDelay;
  private Duration tunnelTimeout;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressControllerTuningOptions instance) {
    instance = (instance != null ? instance : new IngressControllerTuningOptions());
    if (instance != null) {
          this.withClientFinTimeout(instance.getClientFinTimeout());
          this.withClientTimeout(instance.getClientTimeout());
          this.withHeaderBufferBytes(instance.getHeaderBufferBytes());
          this.withHeaderBufferMaxRewriteBytes(instance.getHeaderBufferMaxRewriteBytes());
          this.withHealthCheckInterval(instance.getHealthCheckInterval());
          this.withMaxConnections(instance.getMaxConnections());
          this.withReloadInterval(instance.getReloadInterval());
          this.withServerFinTimeout(instance.getServerFinTimeout());
          this.withServerTimeout(instance.getServerTimeout());
          this.withThreadCount(instance.getThreadCount());
          this.withTlsInspectDelay(instance.getTlsInspectDelay());
          this.withTunnelTimeout(instance.getTunnelTimeout());
          this.withClientFinTimeout(instance.getClientFinTimeout());
          this.withClientTimeout(instance.getClientTimeout());
          this.withHeaderBufferBytes(instance.getHeaderBufferBytes());
          this.withHeaderBufferMaxRewriteBytes(instance.getHeaderBufferMaxRewriteBytes());
          this.withHealthCheckInterval(instance.getHealthCheckInterval());
          this.withMaxConnections(instance.getMaxConnections());
          this.withReloadInterval(instance.getReloadInterval());
          this.withServerFinTimeout(instance.getServerFinTimeout());
          this.withServerTimeout(instance.getServerTimeout());
          this.withThreadCount(instance.getThreadCount());
          this.withTlsInspectDelay(instance.getTlsInspectDelay());
          this.withTunnelTimeout(instance.getTunnelTimeout());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Duration getClientFinTimeout() {
    return this.clientFinTimeout;
  }
  
  public A withClientFinTimeout(Duration clientFinTimeout) {
    this.clientFinTimeout = clientFinTimeout;
    return (A) this;
  }
  
  public boolean hasClientFinTimeout() {
    return this.clientFinTimeout != null;
  }
  
  public Duration getClientTimeout() {
    return this.clientTimeout;
  }
  
  public A withClientTimeout(Duration clientTimeout) {
    this.clientTimeout = clientTimeout;
    return (A) this;
  }
  
  public boolean hasClientTimeout() {
    return this.clientTimeout != null;
  }
  
  public Integer getHeaderBufferBytes() {
    return this.headerBufferBytes;
  }
  
  public A withHeaderBufferBytes(Integer headerBufferBytes) {
    this.headerBufferBytes = headerBufferBytes;
    return (A) this;
  }
  
  public boolean hasHeaderBufferBytes() {
    return this.headerBufferBytes != null;
  }
  
  public Integer getHeaderBufferMaxRewriteBytes() {
    return this.headerBufferMaxRewriteBytes;
  }
  
  public A withHeaderBufferMaxRewriteBytes(Integer headerBufferMaxRewriteBytes) {
    this.headerBufferMaxRewriteBytes = headerBufferMaxRewriteBytes;
    return (A) this;
  }
  
  public boolean hasHeaderBufferMaxRewriteBytes() {
    return this.headerBufferMaxRewriteBytes != null;
  }
  
  public Duration getHealthCheckInterval() {
    return this.healthCheckInterval;
  }
  
  public A withHealthCheckInterval(Duration healthCheckInterval) {
    this.healthCheckInterval = healthCheckInterval;
    return (A) this;
  }
  
  public boolean hasHealthCheckInterval() {
    return this.healthCheckInterval != null;
  }
  
  public Integer getMaxConnections() {
    return this.maxConnections;
  }
  
  public A withMaxConnections(Integer maxConnections) {
    this.maxConnections = maxConnections;
    return (A) this;
  }
  
  public boolean hasMaxConnections() {
    return this.maxConnections != null;
  }
  
  public Duration getReloadInterval() {
    return this.reloadInterval;
  }
  
  public A withReloadInterval(Duration reloadInterval) {
    this.reloadInterval = reloadInterval;
    return (A) this;
  }
  
  public boolean hasReloadInterval() {
    return this.reloadInterval != null;
  }
  
  public Duration getServerFinTimeout() {
    return this.serverFinTimeout;
  }
  
  public A withServerFinTimeout(Duration serverFinTimeout) {
    this.serverFinTimeout = serverFinTimeout;
    return (A) this;
  }
  
  public boolean hasServerFinTimeout() {
    return this.serverFinTimeout != null;
  }
  
  public Duration getServerTimeout() {
    return this.serverTimeout;
  }
  
  public A withServerTimeout(Duration serverTimeout) {
    this.serverTimeout = serverTimeout;
    return (A) this;
  }
  
  public boolean hasServerTimeout() {
    return this.serverTimeout != null;
  }
  
  public Integer getThreadCount() {
    return this.threadCount;
  }
  
  public A withThreadCount(Integer threadCount) {
    this.threadCount = threadCount;
    return (A) this;
  }
  
  public boolean hasThreadCount() {
    return this.threadCount != null;
  }
  
  public Duration getTlsInspectDelay() {
    return this.tlsInspectDelay;
  }
  
  public A withTlsInspectDelay(Duration tlsInspectDelay) {
    this.tlsInspectDelay = tlsInspectDelay;
    return (A) this;
  }
  
  public boolean hasTlsInspectDelay() {
    return this.tlsInspectDelay != null;
  }
  
  public Duration getTunnelTimeout() {
    return this.tunnelTimeout;
  }
  
  public A withTunnelTimeout(Duration tunnelTimeout) {
    this.tunnelTimeout = tunnelTimeout;
    return (A) this;
  }
  
  public boolean hasTunnelTimeout() {
    return this.tunnelTimeout != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressControllerTuningOptionsFluent that = (IngressControllerTuningOptionsFluent) o;
    if (!java.util.Objects.equals(clientFinTimeout, that.clientFinTimeout)) return false;
    if (!java.util.Objects.equals(clientTimeout, that.clientTimeout)) return false;
    if (!java.util.Objects.equals(headerBufferBytes, that.headerBufferBytes)) return false;
    if (!java.util.Objects.equals(headerBufferMaxRewriteBytes, that.headerBufferMaxRewriteBytes)) return false;
    if (!java.util.Objects.equals(healthCheckInterval, that.healthCheckInterval)) return false;
    if (!java.util.Objects.equals(maxConnections, that.maxConnections)) return false;
    if (!java.util.Objects.equals(reloadInterval, that.reloadInterval)) return false;
    if (!java.util.Objects.equals(serverFinTimeout, that.serverFinTimeout)) return false;
    if (!java.util.Objects.equals(serverTimeout, that.serverTimeout)) return false;
    if (!java.util.Objects.equals(threadCount, that.threadCount)) return false;
    if (!java.util.Objects.equals(tlsInspectDelay, that.tlsInspectDelay)) return false;
    if (!java.util.Objects.equals(tunnelTimeout, that.tunnelTimeout)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientFinTimeout,  clientTimeout,  headerBufferBytes,  headerBufferMaxRewriteBytes,  healthCheckInterval,  maxConnections,  reloadInterval,  serverFinTimeout,  serverTimeout,  threadCount,  tlsInspectDelay,  tunnelTimeout,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientFinTimeout != null) { sb.append("clientFinTimeout:"); sb.append(clientFinTimeout + ","); }
    if (clientTimeout != null) { sb.append("clientTimeout:"); sb.append(clientTimeout + ","); }
    if (headerBufferBytes != null) { sb.append("headerBufferBytes:"); sb.append(headerBufferBytes + ","); }
    if (headerBufferMaxRewriteBytes != null) { sb.append("headerBufferMaxRewriteBytes:"); sb.append(headerBufferMaxRewriteBytes + ","); }
    if (healthCheckInterval != null) { sb.append("healthCheckInterval:"); sb.append(healthCheckInterval + ","); }
    if (maxConnections != null) { sb.append("maxConnections:"); sb.append(maxConnections + ","); }
    if (reloadInterval != null) { sb.append("reloadInterval:"); sb.append(reloadInterval + ","); }
    if (serverFinTimeout != null) { sb.append("serverFinTimeout:"); sb.append(serverFinTimeout + ","); }
    if (serverTimeout != null) { sb.append("serverTimeout:"); sb.append(serverTimeout + ","); }
    if (threadCount != null) { sb.append("threadCount:"); sb.append(threadCount + ","); }
    if (tlsInspectDelay != null) { sb.append("tlsInspectDelay:"); sb.append(tlsInspectDelay + ","); }
    if (tunnelTimeout != null) { sb.append("tunnelTimeout:"); sb.append(tunnelTimeout + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}