package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MTUMigrationFluent<A extends MTUMigrationFluent<A>> extends BaseFluent<A>{
  public MTUMigrationFluent() {
  }
  
  public MTUMigrationFluent(MTUMigration instance) {
    this.copyInstance(instance);
  }
  private MTUMigrationValuesBuilder machine;
  private MTUMigrationValuesBuilder network;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MTUMigration instance) {
    instance = (instance != null ? instance : new MTUMigration());
    if (instance != null) {
          this.withMachine(instance.getMachine());
          this.withNetwork(instance.getNetwork());
          this.withMachine(instance.getMachine());
          this.withNetwork(instance.getNetwork());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public MTUMigrationValues buildMachine() {
    return this.machine != null ? this.machine.build() : null;
  }
  
  public A withMachine(MTUMigrationValues machine) {
    this._visitables.remove(this.machine);
    if (machine != null) {
        this.machine = new MTUMigrationValuesBuilder(machine);
        this._visitables.get("machine").add(this.machine);
    } else {
        this.machine = null;
        this._visitables.get("machine").remove(this.machine);
    }
    return (A) this;
  }
  
  public boolean hasMachine() {
    return this.machine != null;
  }
  
  public A withNewMachine(Integer from,Integer to) {
    return (A)withMachine(new MTUMigrationValues(from, to));
  }
  
  public MachineNested<A> withNewMachine() {
    return new MachineNested(null);
  }
  
  public MachineNested<A> withNewMachineLike(MTUMigrationValues item) {
    return new MachineNested(item);
  }
  
  public MachineNested<A> editMachine() {
    return withNewMachineLike(java.util.Optional.ofNullable(buildMachine()).orElse(null));
  }
  
  public MachineNested<A> editOrNewMachine() {
    return withNewMachineLike(java.util.Optional.ofNullable(buildMachine()).orElse(new MTUMigrationValuesBuilder().build()));
  }
  
  public MachineNested<A> editOrNewMachineLike(MTUMigrationValues item) {
    return withNewMachineLike(java.util.Optional.ofNullable(buildMachine()).orElse(item));
  }
  
  public MTUMigrationValues buildNetwork() {
    return this.network != null ? this.network.build() : null;
  }
  
  public A withNetwork(MTUMigrationValues network) {
    this._visitables.remove(this.network);
    if (network != null) {
        this.network = new MTUMigrationValuesBuilder(network);
        this._visitables.get("network").add(this.network);
    } else {
        this.network = null;
        this._visitables.get("network").remove(this.network);
    }
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public A withNewNetwork(Integer from,Integer to) {
    return (A)withNetwork(new MTUMigrationValues(from, to));
  }
  
  public NetworkNested<A> withNewNetwork() {
    return new NetworkNested(null);
  }
  
  public NetworkNested<A> withNewNetworkLike(MTUMigrationValues item) {
    return new NetworkNested(item);
  }
  
  public NetworkNested<A> editNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(null));
  }
  
  public NetworkNested<A> editOrNewNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(new MTUMigrationValuesBuilder().build()));
  }
  
  public NetworkNested<A> editOrNewNetworkLike(MTUMigrationValues item) {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MTUMigrationFluent that = (MTUMigrationFluent) o;
    if (!java.util.Objects.equals(machine, that.machine)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(machine,  network,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (machine != null) { sb.append("machine:"); sb.append(machine + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MachineNested<N> extends MTUMigrationValuesFluent<MachineNested<N>> implements Nested<N>{
    MachineNested(MTUMigrationValues item) {
      this.builder = new MTUMigrationValuesBuilder(this, item);
    }
    MTUMigrationValuesBuilder builder;
    
    public N and() {
      return (N) MTUMigrationFluent.this.withMachine(builder.build());
    }
    
    public N endMachine() {
      return and();
    }
    
  
  }
  public class NetworkNested<N> extends MTUMigrationValuesFluent<NetworkNested<N>> implements Nested<N>{
    NetworkNested(MTUMigrationValues item) {
      this.builder = new MTUMigrationValuesBuilder(this, item);
    }
    MTUMigrationValuesBuilder builder;
    
    public N and() {
      return (N) MTUMigrationFluent.this.withNetwork(builder.build());
    }
    
    public N endNetwork() {
      return and();
    }
    
  
  }

}