package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProviderLoadBalancerParametersFluent<A extends ProviderLoadBalancerParametersFluent<A>> extends BaseFluent<A>{
  public ProviderLoadBalancerParametersFluent() {
  }
  
  public ProviderLoadBalancerParametersFluent(ProviderLoadBalancerParameters instance) {
    this.copyInstance(instance);
  }
  private AWSLoadBalancerParametersBuilder aws;
  private GCPLoadBalancerParametersBuilder gcp;
  private IBMLoadBalancerParametersBuilder ibm;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProviderLoadBalancerParameters instance) {
    instance = (instance != null ? instance : new ProviderLoadBalancerParameters());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withGcp(instance.getGcp());
          this.withIbm(instance.getIbm());
          this.withType(instance.getType());
          this.withAws(instance.getAws());
          this.withGcp(instance.getGcp());
          this.withIbm(instance.getIbm());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AWSLoadBalancerParameters buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(AWSLoadBalancerParameters aws) {
    this._visitables.remove(this.aws);
    if (aws != null) {
        this.aws = new AWSLoadBalancerParametersBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(AWSLoadBalancerParameters item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AWSLoadBalancerParametersBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(AWSLoadBalancerParameters item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public GCPLoadBalancerParameters buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(GCPLoadBalancerParameters gcp) {
    this._visitables.remove(this.gcp);
    if (gcp != null) {
        this.gcp = new GCPLoadBalancerParametersBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public A withNewGcp(String clientAccess) {
    return (A)withGcp(new GCPLoadBalancerParameters(clientAccess));
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(GCPLoadBalancerParameters item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new GCPLoadBalancerParametersBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(GCPLoadBalancerParameters item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public IBMLoadBalancerParameters buildIbm() {
    return this.ibm != null ? this.ibm.build() : null;
  }
  
  public A withIbm(IBMLoadBalancerParameters ibm) {
    this._visitables.remove(this.ibm);
    if (ibm != null) {
        this.ibm = new IBMLoadBalancerParametersBuilder(ibm);
        this._visitables.get("ibm").add(this.ibm);
    } else {
        this.ibm = null;
        this._visitables.get("ibm").remove(this.ibm);
    }
    return (A) this;
  }
  
  public boolean hasIbm() {
    return this.ibm != null;
  }
  
  public A withNewIbm(String protocol) {
    return (A)withIbm(new IBMLoadBalancerParameters(protocol));
  }
  
  public IbmNested<A> withNewIbm() {
    return new IbmNested(null);
  }
  
  public IbmNested<A> withNewIbmLike(IBMLoadBalancerParameters item) {
    return new IbmNested(item);
  }
  
  public IbmNested<A> editIbm() {
    return withNewIbmLike(java.util.Optional.ofNullable(buildIbm()).orElse(null));
  }
  
  public IbmNested<A> editOrNewIbm() {
    return withNewIbmLike(java.util.Optional.ofNullable(buildIbm()).orElse(new IBMLoadBalancerParametersBuilder().build()));
  }
  
  public IbmNested<A> editOrNewIbmLike(IBMLoadBalancerParameters item) {
    return withNewIbmLike(java.util.Optional.ofNullable(buildIbm()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProviderLoadBalancerParametersFluent that = (ProviderLoadBalancerParametersFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(ibm, that.ibm)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  gcp,  ibm,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibm != null) { sb.append("ibm:"); sb.append(ibm + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends AWSLoadBalancerParametersFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) ProviderLoadBalancerParametersFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends GCPLoadBalancerParametersFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) ProviderLoadBalancerParametersFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }
  public class IbmNested<N> extends IBMLoadBalancerParametersFluent<IbmNested<N>> implements Nested<N>{
    IbmNested(IBMLoadBalancerParameters item) {
      this.builder = new IBMLoadBalancerParametersBuilder(this, item);
    }
    IBMLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) ProviderLoadBalancerParametersFluent.this.withIbm(builder.build());
    }
    
    public N endIbm() {
      return and();
    }
    
  
  }

}