package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageSpecBuilder extends StorageSpecFluent<StorageSpecBuilder> implements VisitableBuilder<StorageSpec,StorageSpecBuilder>{
  public StorageSpecBuilder() {
    this(new StorageSpec());
  }
  
  public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
    this(fluent, new StorageSpec());
  }
  
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageSpecBuilder(StorageSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageSpecFluent<?> fluent;
  
  public StorageSpec build() {
    StorageSpec buildable = new StorageSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides(),fluent.getVsphereStorageDriver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}