/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.NodeStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeStatusFluent<A extends NodeStatusFluent<A>>
extends BaseFluent<A> {
    private Integer currentRevision;
    private Integer lastFailedCount;
    private String lastFailedReason;
    private Integer lastFailedRevision;
    private List<String> lastFailedRevisionErrors = new ArrayList<String>();
    private String lastFailedTime;
    private Integer lastFallbackCount;
    private String nodeName;
    private Integer targetRevision;
    private Map<String, Object> additionalProperties;

    public NodeStatusFluent() {
    }

    public NodeStatusFluent(NodeStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeStatus instance) {
        NodeStatus nodeStatus = instance = instance != null ? instance : new NodeStatus();
        if (instance != null) {
            this.withCurrentRevision(instance.getCurrentRevision());
            this.withLastFailedCount(instance.getLastFailedCount());
            this.withLastFailedReason(instance.getLastFailedReason());
            this.withLastFailedRevision(instance.getLastFailedRevision());
            this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
            this.withLastFailedTime(instance.getLastFailedTime());
            this.withLastFallbackCount(instance.getLastFallbackCount());
            this.withNodeName(instance.getNodeName());
            this.withTargetRevision(instance.getTargetRevision());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCurrentRevision() {
        return this.currentRevision;
    }

    public A withCurrentRevision(Integer currentRevision) {
        this.currentRevision = currentRevision;
        return (A)((Object)this);
    }

    public boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    public Integer getLastFailedCount() {
        return this.lastFailedCount;
    }

    public A withLastFailedCount(Integer lastFailedCount) {
        this.lastFailedCount = lastFailedCount;
        return (A)((Object)this);
    }

    public boolean hasLastFailedCount() {
        return this.lastFailedCount != null;
    }

    public String getLastFailedReason() {
        return this.lastFailedReason;
    }

    public A withLastFailedReason(String lastFailedReason) {
        this.lastFailedReason = lastFailedReason;
        return (A)((Object)this);
    }

    public boolean hasLastFailedReason() {
        return this.lastFailedReason != null;
    }

    public Integer getLastFailedRevision() {
        return this.lastFailedRevision;
    }

    public A withLastFailedRevision(Integer lastFailedRevision) {
        this.lastFailedRevision = lastFailedRevision;
        return (A)((Object)this);
    }

    public boolean hasLastFailedRevision() {
        return this.lastFailedRevision != null;
    }

    public A addToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.add(index, item);
        return (A)((Object)this);
    }

    public A setToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.set(index, item);
        return (A)((Object)this);
    }

    public A addToLastFailedRevisionErrors(String ... items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLastFailedRevisionErrors(Collection<String> items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLastFailedRevisionErrors(String ... items) {
        if (this.lastFailedRevisionErrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLastFailedRevisionErrors(Collection<String> items) {
        if (this.lastFailedRevisionErrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors;
    }

    public String getLastFailedRevisionError(int index) {
        return this.lastFailedRevisionErrors.get(index);
    }

    public String getFirstLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(0);
    }

    public String getLastLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(this.lastFailedRevisionErrors.size() - 1);
    }

    public String getMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors) {
        if (lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        } else {
            this.lastFailedRevisionErrors = null;
        }
        return (A)((Object)this);
    }

    public A withLastFailedRevisionErrors(String ... lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors.clear();
            this._visitables.remove((Object)"lastFailedRevisionErrors");
        }
        if (lastFailedRevisionErrors != null) {
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors != null && !this.lastFailedRevisionErrors.isEmpty();
    }

    public String getLastFailedTime() {
        return this.lastFailedTime;
    }

    public A withLastFailedTime(String lastFailedTime) {
        this.lastFailedTime = lastFailedTime;
        return (A)((Object)this);
    }

    public boolean hasLastFailedTime() {
        return this.lastFailedTime != null;
    }

    public Integer getLastFallbackCount() {
        return this.lastFallbackCount;
    }

    public A withLastFallbackCount(Integer lastFallbackCount) {
        this.lastFallbackCount = lastFallbackCount;
        return (A)((Object)this);
    }

    public boolean hasLastFallbackCount() {
        return this.lastFallbackCount != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public Integer getTargetRevision() {
        return this.targetRevision;
    }

    public A withTargetRevision(Integer targetRevision) {
        this.targetRevision = targetRevision;
        return (A)((Object)this);
    }

    public boolean hasTargetRevision() {
        return this.targetRevision != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluent that = (NodeStatusFluent)((Object)o);
        if (!Objects.equals(this.currentRevision, that.currentRevision)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedCount, that.lastFailedCount)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedReason, that.lastFailedReason)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedRevision, that.lastFailedRevision)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedRevisionErrors, that.lastFailedRevisionErrors)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedTime, that.lastFailedTime)) {
            return false;
        }
        if (!Objects.equals(this.lastFallbackCount, that.lastFallbackCount)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.targetRevision, that.targetRevision)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.currentRevision, this.lastFailedCount, this.lastFailedReason, this.lastFailedRevision, this.lastFailedRevisionErrors, this.lastFailedTime, this.lastFallbackCount, this.nodeName, this.targetRevision, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentRevision != null) {
            sb.append("currentRevision:");
            sb.append(this.currentRevision + ",");
        }
        if (this.lastFailedCount != null) {
            sb.append("lastFailedCount:");
            sb.append(this.lastFailedCount + ",");
        }
        if (this.lastFailedReason != null) {
            sb.append("lastFailedReason:");
            sb.append(this.lastFailedReason + ",");
        }
        if (this.lastFailedRevision != null) {
            sb.append("lastFailedRevision:");
            sb.append(this.lastFailedRevision + ",");
        }
        if (this.lastFailedRevisionErrors != null && !this.lastFailedRevisionErrors.isEmpty()) {
            sb.append("lastFailedRevisionErrors:");
            sb.append(this.lastFailedRevisionErrors + ",");
        }
        if (this.lastFailedTime != null) {
            sb.append("lastFailedTime:");
            sb.append(this.lastFailedTime + ",");
        }
        if (this.lastFallbackCount != null) {
            sb.append("lastFallbackCount:");
            sb.append(this.lastFallbackCount + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRevision != null) {
            sb.append("targetRevision:");
            sb.append(this.targetRevision + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

