package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkMigrationBuilder extends NetworkMigrationFluent<NetworkMigrationBuilder> implements VisitableBuilder<NetworkMigration,NetworkMigrationBuilder>{
  public NetworkMigrationBuilder() {
    this(new NetworkMigration());
  }
  
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent) {
    this(fluent, new NetworkMigration());
  }
  
  public NetworkMigrationBuilder(NetworkMigrationFluent<?> fluent,NetworkMigration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkMigrationBuilder(NetworkMigration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkMigrationFluent<?> fluent;
  
  public NetworkMigration build() {
    NetworkMigration buildable = new NetworkMigration(fluent.buildFeatures(),fluent.getMode(),fluent.buildMtu(),fluent.getNetworkType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}