package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GathererStatusBuilder extends GathererStatusFluent<GathererStatusBuilder> implements VisitableBuilder<GathererStatus,GathererStatusBuilder>{
  public GathererStatusBuilder() {
    this(new GathererStatus());
  }
  
  public GathererStatusBuilder(GathererStatusFluent<?> fluent) {
    this(fluent, new GathererStatus());
  }
  
  public GathererStatusBuilder(GathererStatusFluent<?> fluent,GathererStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GathererStatusBuilder(GathererStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GathererStatusFluent<?> fluent;
  
  public GathererStatus build() {
    GathererStatus buildable = new GathererStatus(fluent.getConditions(),fluent.getLastGatherDuration(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}