package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InsightsReportFluent<A extends InsightsReportFluent<A>> extends BaseFluent<A>{
  public InsightsReportFluent() {
  }
  
  public InsightsReportFluent(InsightsReport instance) {
    this.copyInstance(instance);
  }
  private String downloadedAt;
  private ArrayList<HealthCheckBuilder> healthChecks = new ArrayList<HealthCheckBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(InsightsReport instance) {
    instance = (instance != null ? instance : new InsightsReport());
    if (instance != null) {
          this.withDownloadedAt(instance.getDownloadedAt());
          this.withHealthChecks(instance.getHealthChecks());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDownloadedAt() {
    return this.downloadedAt;
  }
  
  public A withDownloadedAt(String downloadedAt) {
    this.downloadedAt = downloadedAt;
    return (A) this;
  }
  
  public boolean hasDownloadedAt() {
    return this.downloadedAt != null;
  }
  
  public A addToHealthChecks(int index,HealthCheck item) {
    if (this.healthChecks == null) {this.healthChecks = new ArrayList<HealthCheckBuilder>();}
    HealthCheckBuilder builder = new HealthCheckBuilder(item);
    if (index < 0 || index >= healthChecks.size()) { _visitables.get("healthChecks").add(builder); healthChecks.add(builder); } else { _visitables.get("healthChecks").add(index, builder); healthChecks.add(index, builder);}
    return (A)this;
  }
  
  public A setToHealthChecks(int index,HealthCheck item) {
    if (this.healthChecks == null) {this.healthChecks = new ArrayList<HealthCheckBuilder>();}
    HealthCheckBuilder builder = new HealthCheckBuilder(item);
    if (index < 0 || index >= healthChecks.size()) { _visitables.get("healthChecks").add(builder); healthChecks.add(builder); } else { _visitables.get("healthChecks").set(index, builder); healthChecks.set(index, builder);}
    return (A)this;
  }
  
  public A addToHealthChecks(io.fabric8.openshift.api.model.operator.v1.HealthCheck... items) {
    if (this.healthChecks == null) {this.healthChecks = new ArrayList<HealthCheckBuilder>();}
    for (HealthCheck item : items) {HealthCheckBuilder builder = new HealthCheckBuilder(item);_visitables.get("healthChecks").add(builder);this.healthChecks.add(builder);} return (A)this;
  }
  
  public A addAllToHealthChecks(Collection<HealthCheck> items) {
    if (this.healthChecks == null) {this.healthChecks = new ArrayList<HealthCheckBuilder>();}
    for (HealthCheck item : items) {HealthCheckBuilder builder = new HealthCheckBuilder(item);_visitables.get("healthChecks").add(builder);this.healthChecks.add(builder);} return (A)this;
  }
  
  public A removeFromHealthChecks(io.fabric8.openshift.api.model.operator.v1.HealthCheck... items) {
    if (this.healthChecks == null) return (A)this;
    for (HealthCheck item : items) {HealthCheckBuilder builder = new HealthCheckBuilder(item);_visitables.get("healthChecks").remove(builder); this.healthChecks.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHealthChecks(Collection<HealthCheck> items) {
    if (this.healthChecks == null) return (A)this;
    for (HealthCheck item : items) {HealthCheckBuilder builder = new HealthCheckBuilder(item);_visitables.get("healthChecks").remove(builder); this.healthChecks.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHealthChecks(Predicate<HealthCheckBuilder> predicate) {
    if (healthChecks == null) return (A) this;
    final Iterator<HealthCheckBuilder> each = healthChecks.iterator();
    final List visitables = _visitables.get("healthChecks");
    while (each.hasNext()) {
      HealthCheckBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HealthCheck> buildHealthChecks() {
    return this.healthChecks != null ? build(healthChecks) : null;
  }
  
  public HealthCheck buildHealthCheck(int index) {
    return this.healthChecks.get(index).build();
  }
  
  public HealthCheck buildFirstHealthCheck() {
    return this.healthChecks.get(0).build();
  }
  
  public HealthCheck buildLastHealthCheck() {
    return this.healthChecks.get(healthChecks.size() - 1).build();
  }
  
  public HealthCheck buildMatchingHealthCheck(Predicate<HealthCheckBuilder> predicate) {
      for (HealthCheckBuilder item : healthChecks) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHealthCheck(Predicate<HealthCheckBuilder> predicate) {
      for (HealthCheckBuilder item : healthChecks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHealthChecks(List<HealthCheck> healthChecks) {
    if (this.healthChecks != null) {
      this._visitables.get("healthChecks").clear();
    }
    if (healthChecks != null) {
        this.healthChecks = new ArrayList();
        for (HealthCheck item : healthChecks) {
          this.addToHealthChecks(item);
        }
    } else {
      this.healthChecks = null;
    }
    return (A) this;
  }
  
  public A withHealthChecks(io.fabric8.openshift.api.model.operator.v1.HealthCheck... healthChecks) {
    if (this.healthChecks != null) {
        this.healthChecks.clear();
        _visitables.remove("healthChecks");
    }
    if (healthChecks != null) {
      for (HealthCheck item : healthChecks) {
        this.addToHealthChecks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHealthChecks() {
    return this.healthChecks != null && !this.healthChecks.isEmpty();
  }
  
  public A addNewHealthCheck(String advisorURI,String description,String state,Integer totalRisk) {
    return (A)addToHealthChecks(new HealthCheck(advisorURI, description, state, totalRisk));
  }
  
  public HealthChecksNested<A> addNewHealthCheck() {
    return new HealthChecksNested(-1, null);
  }
  
  public HealthChecksNested<A> addNewHealthCheckLike(HealthCheck item) {
    return new HealthChecksNested(-1, item);
  }
  
  public HealthChecksNested<A> setNewHealthCheckLike(int index,HealthCheck item) {
    return new HealthChecksNested(index, item);
  }
  
  public HealthChecksNested<A> editHealthCheck(int index) {
    if (healthChecks.size() <= index) throw new RuntimeException("Can't edit healthChecks. Index exceeds size.");
    return setNewHealthCheckLike(index, buildHealthCheck(index));
  }
  
  public HealthChecksNested<A> editFirstHealthCheck() {
    if (healthChecks.size() == 0) throw new RuntimeException("Can't edit first healthChecks. The list is empty.");
    return setNewHealthCheckLike(0, buildHealthCheck(0));
  }
  
  public HealthChecksNested<A> editLastHealthCheck() {
    int index = healthChecks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last healthChecks. The list is empty.");
    return setNewHealthCheckLike(index, buildHealthCheck(index));
  }
  
  public HealthChecksNested<A> editMatchingHealthCheck(Predicate<HealthCheckBuilder> predicate) {
    int index = -1;
    for (int i=0;i<healthChecks.size();i++) { 
    if (predicate.test(healthChecks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching healthChecks. No match found.");
    return setNewHealthCheckLike(index, buildHealthCheck(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InsightsReportFluent that = (InsightsReportFluent) o;
    if (!java.util.Objects.equals(downloadedAt, that.downloadedAt)) return false;
    if (!java.util.Objects.equals(healthChecks, that.healthChecks)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(downloadedAt,  healthChecks,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (downloadedAt != null) { sb.append("downloadedAt:"); sb.append(downloadedAt + ","); }
    if (healthChecks != null && !healthChecks.isEmpty()) { sb.append("healthChecks:"); sb.append(healthChecks + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HealthChecksNested<N> extends HealthCheckFluent<HealthChecksNested<N>> implements Nested<N>{
    HealthChecksNested(int index,HealthCheck item) {
      this.index = index;
      this.builder = new HealthCheckBuilder(this, item);
    }
    HealthCheckBuilder builder;
    int index;
    
    public N and() {
      return (N) InsightsReportFluent.this.setToHealthChecks(index,builder.build());
    }
    
    public N endHealthCheck() {
      return and();
    }
    
  
  }

}