package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineManagerSelectorBuilder extends MachineManagerSelectorFluent<MachineManagerSelectorBuilder> implements VisitableBuilder<MachineManagerSelector,MachineManagerSelectorBuilder>{
  public MachineManagerSelectorBuilder() {
    this(new MachineManagerSelector());
  }
  
  public MachineManagerSelectorBuilder(MachineManagerSelectorFluent<?> fluent) {
    this(fluent, new MachineManagerSelector());
  }
  
  public MachineManagerSelectorBuilder(MachineManagerSelectorFluent<?> fluent,MachineManagerSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineManagerSelectorBuilder(MachineManagerSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineManagerSelectorFluent<?> fluent;
  
  public MachineManagerSelector build() {
    MachineManagerSelector buildable = new MachineManagerSelector(fluent.getMode(),fluent.buildPartial());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}