package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeDisruptionPolicyConfigFluent<A extends NodeDisruptionPolicyConfigFluent<A>> extends BaseFluent<A>{
  public NodeDisruptionPolicyConfigFluent() {
  }
  
  public NodeDisruptionPolicyConfigFluent(NodeDisruptionPolicyConfig instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NodeDisruptionPolicySpecFileBuilder> files = new ArrayList<NodeDisruptionPolicySpecFileBuilder>();
  private NodeDisruptionPolicySpecSSHKeyBuilder sshkey;
  private ArrayList<NodeDisruptionPolicySpecUnitBuilder> units = new ArrayList<NodeDisruptionPolicySpecUnitBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeDisruptionPolicyConfig instance) {
    instance = (instance != null ? instance : new NodeDisruptionPolicyConfig());
    if (instance != null) {
          this.withFiles(instance.getFiles());
          this.withSshkey(instance.getSshkey());
          this.withUnits(instance.getUnits());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFiles(int index,NodeDisruptionPolicySpecFile item) {
    if (this.files == null) {this.files = new ArrayList<NodeDisruptionPolicySpecFileBuilder>();}
    NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
    if (index < 0 || index >= files.size()) { _visitables.get("files").add(builder); files.add(builder); } else { _visitables.get("files").add(index, builder); files.add(index, builder);}
    return (A)this;
  }
  
  public A setToFiles(int index,NodeDisruptionPolicySpecFile item) {
    if (this.files == null) {this.files = new ArrayList<NodeDisruptionPolicySpecFileBuilder>();}
    NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
    if (index < 0 || index >= files.size()) { _visitables.get("files").add(builder); files.add(builder); } else { _visitables.get("files").set(index, builder); files.set(index, builder);}
    return (A)this;
  }
  
  public A addToFiles(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFile... items) {
    if (this.files == null) {this.files = new ArrayList<NodeDisruptionPolicySpecFileBuilder>();}
    for (NodeDisruptionPolicySpecFile item : items) {NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);_visitables.get("files").add(builder);this.files.add(builder);} return (A)this;
  }
  
  public A addAllToFiles(Collection<NodeDisruptionPolicySpecFile> items) {
    if (this.files == null) {this.files = new ArrayList<NodeDisruptionPolicySpecFileBuilder>();}
    for (NodeDisruptionPolicySpecFile item : items) {NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);_visitables.get("files").add(builder);this.files.add(builder);} return (A)this;
  }
  
  public A removeFromFiles(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFile... items) {
    if (this.files == null) return (A)this;
    for (NodeDisruptionPolicySpecFile item : items) {NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);_visitables.get("files").remove(builder); this.files.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFiles(Collection<NodeDisruptionPolicySpecFile> items) {
    if (this.files == null) return (A)this;
    for (NodeDisruptionPolicySpecFile item : items) {NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);_visitables.get("files").remove(builder); this.files.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFiles(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
    if (files == null) return (A) this;
    final Iterator<NodeDisruptionPolicySpecFileBuilder> each = files.iterator();
    final List visitables = _visitables.get("files");
    while (each.hasNext()) {
      NodeDisruptionPolicySpecFileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeDisruptionPolicySpecFile> buildFiles() {
    return this.files != null ? build(files) : null;
  }
  
  public NodeDisruptionPolicySpecFile buildFile(int index) {
    return this.files.get(index).build();
  }
  
  public NodeDisruptionPolicySpecFile buildFirstFile() {
    return this.files.get(0).build();
  }
  
  public NodeDisruptionPolicySpecFile buildLastFile() {
    return this.files.get(files.size() - 1).build();
  }
  
  public NodeDisruptionPolicySpecFile buildMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
      for (NodeDisruptionPolicySpecFileBuilder item : files) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
      for (NodeDisruptionPolicySpecFileBuilder item : files) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFiles(List<NodeDisruptionPolicySpecFile> files) {
    if (this.files != null) {
      this._visitables.get("files").clear();
    }
    if (files != null) {
        this.files = new ArrayList();
        for (NodeDisruptionPolicySpecFile item : files) {
          this.addToFiles(item);
        }
    } else {
      this.files = null;
    }
    return (A) this;
  }
  
  public A withFiles(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFile... files) {
    if (this.files != null) {
        this.files.clear();
        _visitables.remove("files");
    }
    if (files != null) {
      for (NodeDisruptionPolicySpecFile item : files) {
        this.addToFiles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFiles() {
    return this.files != null && !this.files.isEmpty();
  }
  
  public FilesNested<A> addNewFile() {
    return new FilesNested(-1, null);
  }
  
  public FilesNested<A> addNewFileLike(NodeDisruptionPolicySpecFile item) {
    return new FilesNested(-1, item);
  }
  
  public FilesNested<A> setNewFileLike(int index,NodeDisruptionPolicySpecFile item) {
    return new FilesNested(index, item);
  }
  
  public FilesNested<A> editFile(int index) {
    if (files.size() <= index) throw new RuntimeException("Can't edit files. Index exceeds size.");
    return setNewFileLike(index, buildFile(index));
  }
  
  public FilesNested<A> editFirstFile() {
    if (files.size() == 0) throw new RuntimeException("Can't edit first files. The list is empty.");
    return setNewFileLike(0, buildFile(0));
  }
  
  public FilesNested<A> editLastFile() {
    int index = files.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last files. The list is empty.");
    return setNewFileLike(index, buildFile(index));
  }
  
  public FilesNested<A> editMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<files.size();i++) { 
    if (predicate.test(files.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching files. No match found.");
    return setNewFileLike(index, buildFile(index));
  }
  
  public NodeDisruptionPolicySpecSSHKey buildSshkey() {
    return this.sshkey != null ? this.sshkey.build() : null;
  }
  
  public A withSshkey(NodeDisruptionPolicySpecSSHKey sshkey) {
    this._visitables.remove("sshkey");
    if (sshkey != null) {
        this.sshkey = new NodeDisruptionPolicySpecSSHKeyBuilder(sshkey);
        this._visitables.get("sshkey").add(this.sshkey);
    } else {
        this.sshkey = null;
        this._visitables.get("sshkey").remove(this.sshkey);
    }
    return (A) this;
  }
  
  public boolean hasSshkey() {
    return this.sshkey != null;
  }
  
  public SshkeyNested<A> withNewSshkey() {
    return new SshkeyNested(null);
  }
  
  public SshkeyNested<A> withNewSshkeyLike(NodeDisruptionPolicySpecSSHKey item) {
    return new SshkeyNested(item);
  }
  
  public SshkeyNested<A> editSshkey() {
    return withNewSshkeyLike(java.util.Optional.ofNullable(buildSshkey()).orElse(null));
  }
  
  public SshkeyNested<A> editOrNewSshkey() {
    return withNewSshkeyLike(java.util.Optional.ofNullable(buildSshkey()).orElse(new NodeDisruptionPolicySpecSSHKeyBuilder().build()));
  }
  
  public SshkeyNested<A> editOrNewSshkeyLike(NodeDisruptionPolicySpecSSHKey item) {
    return withNewSshkeyLike(java.util.Optional.ofNullable(buildSshkey()).orElse(item));
  }
  
  public A addToUnits(int index,NodeDisruptionPolicySpecUnit item) {
    if (this.units == null) {this.units = new ArrayList<NodeDisruptionPolicySpecUnitBuilder>();}
    NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
    if (index < 0 || index >= units.size()) { _visitables.get("units").add(builder); units.add(builder); } else { _visitables.get("units").add(index, builder); units.add(index, builder);}
    return (A)this;
  }
  
  public A setToUnits(int index,NodeDisruptionPolicySpecUnit item) {
    if (this.units == null) {this.units = new ArrayList<NodeDisruptionPolicySpecUnitBuilder>();}
    NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
    if (index < 0 || index >= units.size()) { _visitables.get("units").add(builder); units.add(builder); } else { _visitables.get("units").set(index, builder); units.set(index, builder);}
    return (A)this;
  }
  
  public A addToUnits(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnit... items) {
    if (this.units == null) {this.units = new ArrayList<NodeDisruptionPolicySpecUnitBuilder>();}
    for (NodeDisruptionPolicySpecUnit item : items) {NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);_visitables.get("units").add(builder);this.units.add(builder);} return (A)this;
  }
  
  public A addAllToUnits(Collection<NodeDisruptionPolicySpecUnit> items) {
    if (this.units == null) {this.units = new ArrayList<NodeDisruptionPolicySpecUnitBuilder>();}
    for (NodeDisruptionPolicySpecUnit item : items) {NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);_visitables.get("units").add(builder);this.units.add(builder);} return (A)this;
  }
  
  public A removeFromUnits(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnit... items) {
    if (this.units == null) return (A)this;
    for (NodeDisruptionPolicySpecUnit item : items) {NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);_visitables.get("units").remove(builder); this.units.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUnits(Collection<NodeDisruptionPolicySpecUnit> items) {
    if (this.units == null) return (A)this;
    for (NodeDisruptionPolicySpecUnit item : items) {NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);_visitables.get("units").remove(builder); this.units.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUnits(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
    if (units == null) return (A) this;
    final Iterator<NodeDisruptionPolicySpecUnitBuilder> each = units.iterator();
    final List visitables = _visitables.get("units");
    while (each.hasNext()) {
      NodeDisruptionPolicySpecUnitBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeDisruptionPolicySpecUnit> buildUnits() {
    return this.units != null ? build(units) : null;
  }
  
  public NodeDisruptionPolicySpecUnit buildUnit(int index) {
    return this.units.get(index).build();
  }
  
  public NodeDisruptionPolicySpecUnit buildFirstUnit() {
    return this.units.get(0).build();
  }
  
  public NodeDisruptionPolicySpecUnit buildLastUnit() {
    return this.units.get(units.size() - 1).build();
  }
  
  public NodeDisruptionPolicySpecUnit buildMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
      for (NodeDisruptionPolicySpecUnitBuilder item : units) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
      for (NodeDisruptionPolicySpecUnitBuilder item : units) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUnits(List<NodeDisruptionPolicySpecUnit> units) {
    if (this.units != null) {
      this._visitables.get("units").clear();
    }
    if (units != null) {
        this.units = new ArrayList();
        for (NodeDisruptionPolicySpecUnit item : units) {
          this.addToUnits(item);
        }
    } else {
      this.units = null;
    }
    return (A) this;
  }
  
  public A withUnits(io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnit... units) {
    if (this.units != null) {
        this.units.clear();
        _visitables.remove("units");
    }
    if (units != null) {
      for (NodeDisruptionPolicySpecUnit item : units) {
        this.addToUnits(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUnits() {
    return this.units != null && !this.units.isEmpty();
  }
  
  public UnitsNested<A> addNewUnit() {
    return new UnitsNested(-1, null);
  }
  
  public UnitsNested<A> addNewUnitLike(NodeDisruptionPolicySpecUnit item) {
    return new UnitsNested(-1, item);
  }
  
  public UnitsNested<A> setNewUnitLike(int index,NodeDisruptionPolicySpecUnit item) {
    return new UnitsNested(index, item);
  }
  
  public UnitsNested<A> editUnit(int index) {
    if (units.size() <= index) throw new RuntimeException("Can't edit units. Index exceeds size.");
    return setNewUnitLike(index, buildUnit(index));
  }
  
  public UnitsNested<A> editFirstUnit() {
    if (units.size() == 0) throw new RuntimeException("Can't edit first units. The list is empty.");
    return setNewUnitLike(0, buildUnit(0));
  }
  
  public UnitsNested<A> editLastUnit() {
    int index = units.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last units. The list is empty.");
    return setNewUnitLike(index, buildUnit(index));
  }
  
  public UnitsNested<A> editMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
    int index = -1;
    for (int i=0;i<units.size();i++) { 
    if (predicate.test(units.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching units. No match found.");
    return setNewUnitLike(index, buildUnit(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeDisruptionPolicyConfigFluent that = (NodeDisruptionPolicyConfigFluent) o;
    if (!java.util.Objects.equals(files, that.files)) return false;
    if (!java.util.Objects.equals(sshkey, that.sshkey)) return false;
    if (!java.util.Objects.equals(units, that.units)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(files,  sshkey,  units,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (files != null && !files.isEmpty()) { sb.append("files:"); sb.append(files + ","); }
    if (sshkey != null) { sb.append("sshkey:"); sb.append(sshkey + ","); }
    if (units != null && !units.isEmpty()) { sb.append("units:"); sb.append(units + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FilesNested<N> extends NodeDisruptionPolicySpecFileFluent<FilesNested<N>> implements Nested<N>{
    FilesNested(int index,NodeDisruptionPolicySpecFile item) {
      this.index = index;
      this.builder = new NodeDisruptionPolicySpecFileBuilder(this, item);
    }
    NodeDisruptionPolicySpecFileBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeDisruptionPolicyConfigFluent.this.setToFiles(index,builder.build());
    }
    
    public N endFile() {
      return and();
    }
    
  
  }
  public class SshkeyNested<N> extends NodeDisruptionPolicySpecSSHKeyFluent<SshkeyNested<N>> implements Nested<N>{
    SshkeyNested(NodeDisruptionPolicySpecSSHKey item) {
      this.builder = new NodeDisruptionPolicySpecSSHKeyBuilder(this, item);
    }
    NodeDisruptionPolicySpecSSHKeyBuilder builder;
    
    public N and() {
      return (N) NodeDisruptionPolicyConfigFluent.this.withSshkey(builder.build());
    }
    
    public N endSshkey() {
      return and();
    }
    
  
  }
  public class UnitsNested<N> extends NodeDisruptionPolicySpecUnitFluent<UnitsNested<N>> implements Nested<N>{
    UnitsNested(int index,NodeDisruptionPolicySpecUnit item) {
      this.index = index;
      this.builder = new NodeDisruptionPolicySpecUnitBuilder(this, item);
    }
    NodeDisruptionPolicySpecUnitBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeDisruptionPolicyConfigFluent.this.setToUnits(index,builder.build());
    }
    
    public N endUnit() {
      return and();
    }
    
  
  }

}