package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSClassicLoadBalancerParametersFluent<A extends AWSClassicLoadBalancerParametersFluent<A>> extends BaseFluent<A>{
  public AWSClassicLoadBalancerParametersFluent() {
  }
  
  public AWSClassicLoadBalancerParametersFluent(AWSClassicLoadBalancerParameters instance) {
    this.copyInstance(instance);
  }
  private String connectionIdleTimeout;
  private AWSSubnetsBuilder subnets;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSClassicLoadBalancerParameters instance) {
    instance = (instance != null ? instance : new AWSClassicLoadBalancerParameters());
    if (instance != null) {
          this.withConnectionIdleTimeout(instance.getConnectionIdleTimeout());
          this.withSubnets(instance.getSubnets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getConnectionIdleTimeout() {
    return this.connectionIdleTimeout;
  }
  
  public A withConnectionIdleTimeout(String connectionIdleTimeout) {
    this.connectionIdleTimeout = connectionIdleTimeout;
    return (A) this;
  }
  
  public boolean hasConnectionIdleTimeout() {
    return this.connectionIdleTimeout != null;
  }
  
  public AWSSubnets buildSubnets() {
    return this.subnets != null ? this.subnets.build() : null;
  }
  
  public A withSubnets(AWSSubnets subnets) {
    this._visitables.remove("subnets");
    if (subnets != null) {
        this.subnets = new AWSSubnetsBuilder(subnets);
        this._visitables.get("subnets").add(this.subnets);
    } else {
        this.subnets = null;
        this._visitables.get("subnets").remove(this.subnets);
    }
    return (A) this;
  }
  
  public boolean hasSubnets() {
    return this.subnets != null;
  }
  
  public SubnetsNested<A> withNewSubnets() {
    return new SubnetsNested(null);
  }
  
  public SubnetsNested<A> withNewSubnetsLike(AWSSubnets item) {
    return new SubnetsNested(item);
  }
  
  public SubnetsNested<A> editSubnets() {
    return withNewSubnetsLike(java.util.Optional.ofNullable(buildSubnets()).orElse(null));
  }
  
  public SubnetsNested<A> editOrNewSubnets() {
    return withNewSubnetsLike(java.util.Optional.ofNullable(buildSubnets()).orElse(new AWSSubnetsBuilder().build()));
  }
  
  public SubnetsNested<A> editOrNewSubnetsLike(AWSSubnets item) {
    return withNewSubnetsLike(java.util.Optional.ofNullable(buildSubnets()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSClassicLoadBalancerParametersFluent that = (AWSClassicLoadBalancerParametersFluent) o;
    if (!java.util.Objects.equals(connectionIdleTimeout, that.connectionIdleTimeout)) return false;
    if (!java.util.Objects.equals(subnets, that.subnets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectionIdleTimeout,  subnets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionIdleTimeout != null) { sb.append("connectionIdleTimeout:"); sb.append(connectionIdleTimeout + ","); }
    if (subnets != null) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SubnetsNested<N> extends AWSSubnetsFluent<SubnetsNested<N>> implements Nested<N>{
    SubnetsNested(AWSSubnets item) {
      this.builder = new AWSSubnetsBuilder(this, item);
    }
    AWSSubnetsBuilder builder;
    
    public N and() {
      return (N) AWSClassicLoadBalancerParametersFluent.this.withSubnets(builder.build());
    }
    
    public N endSubnets() {
      return and();
    }
    
  
  }

}