package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleConfigRouteBuilder extends ConsoleConfigRouteFluent<ConsoleConfigRouteBuilder> implements VisitableBuilder<ConsoleConfigRoute,ConsoleConfigRouteBuilder>{
  public ConsoleConfigRouteBuilder() {
    this(new ConsoleConfigRoute());
  }
  
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent) {
    this(fluent, new ConsoleConfigRoute());
  }
  
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,ConsoleConfigRoute instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleConfigRouteBuilder(ConsoleConfigRoute instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleConfigRouteFluent<?> fluent;
  
  public ConsoleConfigRoute build() {
    ConsoleConfigRoute buildable = new ConsoleConfigRoute(fluent.getHostname(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}