package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineManagerSelectorFluent<A extends MachineManagerSelectorFluent<A>> extends BaseFluent<A>{
  public MachineManagerSelectorFluent() {
  }
  
  public MachineManagerSelectorFluent(MachineManagerSelector instance) {
    this.copyInstance(instance);
  }
  private String mode;
  private PartialSelectorBuilder partial;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineManagerSelector instance) {
    instance = (instance != null ? instance : new MachineManagerSelector());
    if (instance != null) {
          this.withMode(instance.getMode());
          this.withPartial(instance.getPartial());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public PartialSelector buildPartial() {
    return this.partial != null ? this.partial.build() : null;
  }
  
  public A withPartial(PartialSelector partial) {
    this._visitables.remove("partial");
    if (partial != null) {
        this.partial = new PartialSelectorBuilder(partial);
        this._visitables.get("partial").add(this.partial);
    } else {
        this.partial = null;
        this._visitables.get("partial").remove(this.partial);
    }
    return (A) this;
  }
  
  public boolean hasPartial() {
    return this.partial != null;
  }
  
  public PartialNested<A> withNewPartial() {
    return new PartialNested(null);
  }
  
  public PartialNested<A> withNewPartialLike(PartialSelector item) {
    return new PartialNested(item);
  }
  
  public PartialNested<A> editPartial() {
    return withNewPartialLike(java.util.Optional.ofNullable(buildPartial()).orElse(null));
  }
  
  public PartialNested<A> editOrNewPartial() {
    return withNewPartialLike(java.util.Optional.ofNullable(buildPartial()).orElse(new PartialSelectorBuilder().build()));
  }
  
  public PartialNested<A> editOrNewPartialLike(PartialSelector item) {
    return withNewPartialLike(java.util.Optional.ofNullable(buildPartial()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineManagerSelectorFluent that = (MachineManagerSelectorFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(partial, that.partial)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  partial,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (partial != null) { sb.append("partial:"); sb.append(partial + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PartialNested<N> extends PartialSelectorFluent<PartialNested<N>> implements Nested<N>{
    PartialNested(PartialSelector item) {
      this.builder = new PartialSelectorBuilder(this, item);
    }
    PartialSelectorBuilder builder;
    
    public N and() {
      return (N) MachineManagerSelectorFluent.this.withPartial(builder.build());
    }
    
    public N endPartial() {
      return and();
    }
    
  
  }

}