package io.fabric8.openshift.api.model.operator.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeStatusFluent<A extends NodeStatusFluent<A>> extends BaseFluent<A>{
  public NodeStatusFluent() {
  }
  
  public NodeStatusFluent(NodeStatus instance) {
    this.copyInstance(instance);
  }
  private Integer currentDeploymentGeneration;
  private List<String> lastFailedDeploymentErrors = new ArrayList<String>();
  private Integer lastFailedDeploymentGeneration;
  private String nodeName;
  private Integer targetDeploymentGeneration;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeStatus instance) {
    instance = (instance != null ? instance : new NodeStatus());
    if (instance != null) {
          this.withCurrentDeploymentGeneration(instance.getCurrentDeploymentGeneration());
          this.withLastFailedDeploymentErrors(instance.getLastFailedDeploymentErrors());
          this.withLastFailedDeploymentGeneration(instance.getLastFailedDeploymentGeneration());
          this.withNodeName(instance.getNodeName());
          this.withTargetDeploymentGeneration(instance.getTargetDeploymentGeneration());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getCurrentDeploymentGeneration() {
    return this.currentDeploymentGeneration;
  }
  
  public A withCurrentDeploymentGeneration(Integer currentDeploymentGeneration) {
    this.currentDeploymentGeneration = currentDeploymentGeneration;
    return (A) this;
  }
  
  public boolean hasCurrentDeploymentGeneration() {
    return this.currentDeploymentGeneration != null;
  }
  
  public A addToLastFailedDeploymentErrors(int index,String item) {
    if (this.lastFailedDeploymentErrors == null) {this.lastFailedDeploymentErrors = new ArrayList<String>();}
    this.lastFailedDeploymentErrors.add(index, item);
    return (A)this;
  }
  
  public A setToLastFailedDeploymentErrors(int index,String item) {
    if (this.lastFailedDeploymentErrors == null) {this.lastFailedDeploymentErrors = new ArrayList<String>();}
    this.lastFailedDeploymentErrors.set(index, item); return (A)this;
  }
  
  public A addToLastFailedDeploymentErrors(java.lang.String... items) {
    if (this.lastFailedDeploymentErrors == null) {this.lastFailedDeploymentErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedDeploymentErrors.add(item);} return (A)this;
  }
  
  public A addAllToLastFailedDeploymentErrors(Collection<String> items) {
    if (this.lastFailedDeploymentErrors == null) {this.lastFailedDeploymentErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedDeploymentErrors.add(item);} return (A)this;
  }
  
  public A removeFromLastFailedDeploymentErrors(java.lang.String... items) {
    if (this.lastFailedDeploymentErrors == null) return (A)this;
    for (String item : items) { this.lastFailedDeploymentErrors.remove(item);} return (A)this;
  }
  
  public A removeAllFromLastFailedDeploymentErrors(Collection<String> items) {
    if (this.lastFailedDeploymentErrors == null) return (A)this;
    for (String item : items) { this.lastFailedDeploymentErrors.remove(item);} return (A)this;
  }
  
  public List<String> getLastFailedDeploymentErrors() {
    return this.lastFailedDeploymentErrors;
  }
  
  public String getLastFailedDeploymentError(int index) {
    return this.lastFailedDeploymentErrors.get(index);
  }
  
  public String getFirstLastFailedDeploymentError() {
    return this.lastFailedDeploymentErrors.get(0);
  }
  
  public String getLastLastFailedDeploymentError() {
    return this.lastFailedDeploymentErrors.get(lastFailedDeploymentErrors.size() - 1);
  }
  
  public String getMatchingLastFailedDeploymentError(Predicate<String> predicate) {
      for (String item : lastFailedDeploymentErrors) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingLastFailedDeploymentError(Predicate<String> predicate) {
      for (String item : lastFailedDeploymentErrors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLastFailedDeploymentErrors(List<String> lastFailedDeploymentErrors) {
    if (lastFailedDeploymentErrors != null) {
        this.lastFailedDeploymentErrors = new ArrayList();
        for (String item : lastFailedDeploymentErrors) {
          this.addToLastFailedDeploymentErrors(item);
        }
    } else {
      this.lastFailedDeploymentErrors = null;
    }
    return (A) this;
  }
  
  public A withLastFailedDeploymentErrors(java.lang.String... lastFailedDeploymentErrors) {
    if (this.lastFailedDeploymentErrors != null) {
        this.lastFailedDeploymentErrors.clear();
        _visitables.remove("lastFailedDeploymentErrors");
    }
    if (lastFailedDeploymentErrors != null) {
      for (String item : lastFailedDeploymentErrors) {
        this.addToLastFailedDeploymentErrors(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLastFailedDeploymentErrors() {
    return this.lastFailedDeploymentErrors != null && !this.lastFailedDeploymentErrors.isEmpty();
  }
  
  public Integer getLastFailedDeploymentGeneration() {
    return this.lastFailedDeploymentGeneration;
  }
  
  public A withLastFailedDeploymentGeneration(Integer lastFailedDeploymentGeneration) {
    this.lastFailedDeploymentGeneration = lastFailedDeploymentGeneration;
    return (A) this;
  }
  
  public boolean hasLastFailedDeploymentGeneration() {
    return this.lastFailedDeploymentGeneration != null;
  }
  
  public String getNodeName() {
    return this.nodeName;
  }
  
  public A withNodeName(String nodeName) {
    this.nodeName = nodeName;
    return (A) this;
  }
  
  public boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  public Integer getTargetDeploymentGeneration() {
    return this.targetDeploymentGeneration;
  }
  
  public A withTargetDeploymentGeneration(Integer targetDeploymentGeneration) {
    this.targetDeploymentGeneration = targetDeploymentGeneration;
    return (A) this;
  }
  
  public boolean hasTargetDeploymentGeneration() {
    return this.targetDeploymentGeneration != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeStatusFluent that = (NodeStatusFluent) o;
    if (!java.util.Objects.equals(currentDeploymentGeneration, that.currentDeploymentGeneration)) return false;
    if (!java.util.Objects.equals(lastFailedDeploymentErrors, that.lastFailedDeploymentErrors)) return false;
    if (!java.util.Objects.equals(lastFailedDeploymentGeneration, that.lastFailedDeploymentGeneration)) return false;
    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;
    if (!java.util.Objects.equals(targetDeploymentGeneration, that.targetDeploymentGeneration)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(currentDeploymentGeneration,  lastFailedDeploymentErrors,  lastFailedDeploymentGeneration,  nodeName,  targetDeploymentGeneration,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentDeploymentGeneration != null) { sb.append("currentDeploymentGeneration:"); sb.append(currentDeploymentGeneration + ","); }
    if (lastFailedDeploymentErrors != null && !lastFailedDeploymentErrors.isEmpty()) { sb.append("lastFailedDeploymentErrors:"); sb.append(lastFailedDeploymentErrors + ","); }
    if (lastFailedDeploymentGeneration != null) { sb.append("lastFailedDeploymentGeneration:"); sb.append(lastFailedDeploymentGeneration + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (targetDeploymentGeneration != null) { sb.append("targetDeploymentGeneration:"); sb.append(targetDeploymentGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}