package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VersionAvailabilityFluent<A extends VersionAvailabilityFluent<A>> extends BaseFluent<A>{
  public VersionAvailabilityFluent() {
  }
  
  public VersionAvailabilityFluent(VersionAvailability instance) {
    this.copyInstance(instance);
  }
  private List<String> errors = new ArrayList<String>();
  private ArrayList<GenerationHistoryBuilder> generations = new ArrayList<GenerationHistoryBuilder>();
  private Integer readyReplicas;
  private Integer updatedReplicas;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VersionAvailability instance) {
    instance = (instance != null ? instance : new VersionAvailability());
    if (instance != null) {
          this.withErrors(instance.getErrors());
          this.withGenerations(instance.getGenerations());
          this.withReadyReplicas(instance.getReadyReplicas());
          this.withUpdatedReplicas(instance.getUpdatedReplicas());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToErrors(int index,String item) {
    if (this.errors == null) {this.errors = new ArrayList<String>();}
    this.errors.add(index, item);
    return (A)this;
  }
  
  public A setToErrors(int index,String item) {
    if (this.errors == null) {this.errors = new ArrayList<String>();}
    this.errors.set(index, item); return (A)this;
  }
  
  public A addToErrors(java.lang.String... items) {
    if (this.errors == null) {this.errors = new ArrayList<String>();}
    for (String item : items) {this.errors.add(item);} return (A)this;
  }
  
  public A addAllToErrors(Collection<String> items) {
    if (this.errors == null) {this.errors = new ArrayList<String>();}
    for (String item : items) {this.errors.add(item);} return (A)this;
  }
  
  public A removeFromErrors(java.lang.String... items) {
    if (this.errors == null) return (A)this;
    for (String item : items) { this.errors.remove(item);} return (A)this;
  }
  
  public A removeAllFromErrors(Collection<String> items) {
    if (this.errors == null) return (A)this;
    for (String item : items) { this.errors.remove(item);} return (A)this;
  }
  
  public List<String> getErrors() {
    return this.errors;
  }
  
  public String getError(int index) {
    return this.errors.get(index);
  }
  
  public String getFirstError() {
    return this.errors.get(0);
  }
  
  public String getLastError() {
    return this.errors.get(errors.size() - 1);
  }
  
  public String getMatchingError(Predicate<String> predicate) {
      for (String item : errors) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingError(Predicate<String> predicate) {
      for (String item : errors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withErrors(List<String> errors) {
    if (errors != null) {
        this.errors = new ArrayList();
        for (String item : errors) {
          this.addToErrors(item);
        }
    } else {
      this.errors = null;
    }
    return (A) this;
  }
  
  public A withErrors(java.lang.String... errors) {
    if (this.errors != null) {
        this.errors.clear();
        _visitables.remove("errors");
    }
    if (errors != null) {
      for (String item : errors) {
        this.addToErrors(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasErrors() {
    return this.errors != null && !this.errors.isEmpty();
  }
  
  public A addToGenerations(int index,GenerationHistory item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationHistoryBuilder>();}
    GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);
    if (index < 0 || index >= generations.size()) {
        _visitables.get("generations").add(builder);
        generations.add(builder);
    } else {
        _visitables.get("generations").add(builder);
        generations.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGenerations(int index,GenerationHistory item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationHistoryBuilder>();}
    GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);
    if (index < 0 || index >= generations.size()) {
        _visitables.get("generations").add(builder);
        generations.add(builder);
    } else {
        _visitables.get("generations").add(builder);
        generations.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1alpha1.GenerationHistory... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationHistoryBuilder>();}
    for (GenerationHistory item : items) {GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  
  public A addAllToGenerations(Collection<GenerationHistory> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationHistoryBuilder>();}
    for (GenerationHistory item : items) {GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1alpha1.GenerationHistory... items) {
    if (this.generations == null) return (A)this;
    for (GenerationHistory item : items) {GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGenerations(Collection<GenerationHistory> items) {
    if (this.generations == null) return (A)this;
    for (GenerationHistory item : items) {GenerationHistoryBuilder builder = new GenerationHistoryBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGenerations(Predicate<GenerationHistoryBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<GenerationHistoryBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      GenerationHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GenerationHistory> buildGenerations() {
    return this.generations != null ? build(generations) : null;
  }
  
  public GenerationHistory buildGeneration(int index) {
    return this.generations.get(index).build();
  }
  
  public GenerationHistory buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  
  public GenerationHistory buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  
  public GenerationHistory buildMatchingGeneration(Predicate<GenerationHistoryBuilder> predicate) {
      for (GenerationHistoryBuilder item : generations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGeneration(Predicate<GenerationHistoryBuilder> predicate) {
      for (GenerationHistoryBuilder item : generations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGenerations(List<GenerationHistory> generations) {
    if (this.generations != null) {
      this._visitables.get("generations").clear();
    }
    if (generations != null) {
        this.generations = new ArrayList();
        for (GenerationHistory item : generations) {
          this.addToGenerations(item);
        }
    } else {
      this.generations = null;
    }
    return (A) this;
  }
  
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1alpha1.GenerationHistory... generations) {
    if (this.generations != null) {
        this.generations.clear();
        _visitables.remove("generations");
    }
    if (generations != null) {
      for (GenerationHistory item : generations) {
        this.addToGenerations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGenerations() {
    return this.generations != null && !this.generations.isEmpty();
  }
  
  public A addNewGeneration(String group,Long lastGeneration,String name,String namespace,String resource) {
    return (A)addToGenerations(new GenerationHistory(group, lastGeneration, name, namespace, resource));
  }
  
  public GenerationsNested<A> addNewGeneration() {
    return new GenerationsNested(-1, null);
  }
  
  public GenerationsNested<A> addNewGenerationLike(GenerationHistory item) {
    return new GenerationsNested(-1, item);
  }
  
  public GenerationsNested<A> setNewGenerationLike(int index,GenerationHistory item) {
    return new GenerationsNested(index, item);
  }
  
  public GenerationsNested<A> editGeneration(int index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  
  public GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public GenerationsNested<A> editMatchingGeneration(Predicate<GenerationHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas = readyReplicas;
    return (A) this;
  }
  
  public boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  
  public Integer getUpdatedReplicas() {
    return this.updatedReplicas;
  }
  
  public A withUpdatedReplicas(Integer updatedReplicas) {
    this.updatedReplicas = updatedReplicas;
    return (A) this;
  }
  
  public boolean hasUpdatedReplicas() {
    return this.updatedReplicas != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VersionAvailabilityFluent that = (VersionAvailabilityFluent) o;
    if (!java.util.Objects.equals(errors, that.errors)) return false;
    if (!java.util.Objects.equals(generations, that.generations)) return false;
    if (!java.util.Objects.equals(readyReplicas, that.readyReplicas)) return false;
    if (!java.util.Objects.equals(updatedReplicas, that.updatedReplicas)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(errors,  generations,  readyReplicas,  updatedReplicas,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (errors != null && !errors.isEmpty()) { sb.append("errors:"); sb.append(errors + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (updatedReplicas != null) { sb.append("updatedReplicas:"); sb.append(updatedReplicas + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GenerationsNested<N> extends GenerationHistoryFluent<GenerationsNested<N>> implements Nested<N>{
    GenerationsNested(int index,GenerationHistory item) {
      this.index = index;
      this.builder = new GenerationHistoryBuilder(this, item);
    }
    GenerationHistoryBuilder builder;
    int index;
    
    public N and() {
      return (N) VersionAvailabilityFluent.this.setToGenerations(index,builder.build());
    }
    
    public N endGeneration() {
      return and();
    }
    
  
  }

}