/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters;
import io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersBuilder;
import io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent;
import io.fabric8.openshift.api.model.operator.v1.GCPLoadBalancerParameters;
import io.fabric8.openshift.api.model.operator.v1.GCPLoadBalancerParametersBuilder;
import io.fabric8.openshift.api.model.operator.v1.GCPLoadBalancerParametersFluent;
import io.fabric8.openshift.api.model.operator.v1.IBMLoadBalancerParameters;
import io.fabric8.openshift.api.model.operator.v1.IBMLoadBalancerParametersBuilder;
import io.fabric8.openshift.api.model.operator.v1.IBMLoadBalancerParametersFluent;
import io.fabric8.openshift.api.model.operator.v1.OpenStackLoadBalancerParameters;
import io.fabric8.openshift.api.model.operator.v1.OpenStackLoadBalancerParametersBuilder;
import io.fabric8.openshift.api.model.operator.v1.OpenStackLoadBalancerParametersFluent;
import io.fabric8.openshift.api.model.operator.v1.ProviderLoadBalancerParameters;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProviderLoadBalancerParametersFluent<A extends ProviderLoadBalancerParametersFluent<A>>
extends BaseFluent<A> {
    private AWSLoadBalancerParametersBuilder aws;
    private GCPLoadBalancerParametersBuilder gcp;
    private IBMLoadBalancerParametersBuilder ibm;
    private OpenStackLoadBalancerParametersBuilder openstack;
    private String type;
    private Map<String, Object> additionalProperties;

    public ProviderLoadBalancerParametersFluent() {
    }

    public ProviderLoadBalancerParametersFluent(ProviderLoadBalancerParameters instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProviderLoadBalancerParameters instance) {
        ProviderLoadBalancerParameters providerLoadBalancerParameters = instance = instance != null ? instance : new ProviderLoadBalancerParameters();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withGcp(instance.getGcp());
            this.withIbm(instance.getIbm());
            this.withOpenstack(instance.getOpenstack());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSLoadBalancerParameters buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(AWSLoadBalancerParameters aws) {
        this._visitables.remove((Object)"aws");
        if (aws != null) {
            this.aws = new AWSLoadBalancerParametersBuilder(aws);
            this._visitables.get((Object)"aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get((Object)"aws").remove((Object)this.aws);
        }
        return (A)((Object)this);
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(AWSLoadBalancerParameters item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AWSLoadBalancerParametersBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AWSLoadBalancerParameters item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public GCPLoadBalancerParameters buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    public A withGcp(GCPLoadBalancerParameters gcp) {
        this._visitables.remove((Object)"gcp");
        if (gcp != null) {
            this.gcp = new GCPLoadBalancerParametersBuilder(gcp);
            this._visitables.get((Object)"gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get((Object)"gcp").remove((Object)this.gcp);
        }
        return (A)((Object)this);
    }

    public boolean hasGcp() {
        return this.gcp != null;
    }

    public A withNewGcp(String clientAccess) {
        return this.withGcp(new GCPLoadBalancerParameters(clientAccess));
    }

    public GcpNested<A> withNewGcp() {
        return new GcpNested(null);
    }

    public GcpNested<A> withNewGcpLike(GCPLoadBalancerParameters item) {
        return new GcpNested(item);
    }

    public GcpNested<A> editGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(null));
    }

    public GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(new GCPLoadBalancerParametersBuilder().build()));
    }

    public GcpNested<A> editOrNewGcpLike(GCPLoadBalancerParameters item) {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(item));
    }

    public IBMLoadBalancerParameters buildIbm() {
        return this.ibm != null ? this.ibm.build() : null;
    }

    public A withIbm(IBMLoadBalancerParameters ibm) {
        this._visitables.remove((Object)"ibm");
        if (ibm != null) {
            this.ibm = new IBMLoadBalancerParametersBuilder(ibm);
            this._visitables.get((Object)"ibm").add(this.ibm);
        } else {
            this.ibm = null;
            this._visitables.get((Object)"ibm").remove((Object)this.ibm);
        }
        return (A)((Object)this);
    }

    public boolean hasIbm() {
        return this.ibm != null;
    }

    public A withNewIbm(String protocol) {
        return this.withIbm(new IBMLoadBalancerParameters(protocol));
    }

    public IbmNested<A> withNewIbm() {
        return new IbmNested(null);
    }

    public IbmNested<A> withNewIbmLike(IBMLoadBalancerParameters item) {
        return new IbmNested(item);
    }

    public IbmNested<A> editIbm() {
        return this.withNewIbmLike(Optional.ofNullable(this.buildIbm()).orElse(null));
    }

    public IbmNested<A> editOrNewIbm() {
        return this.withNewIbmLike(Optional.ofNullable(this.buildIbm()).orElse(new IBMLoadBalancerParametersBuilder().build()));
    }

    public IbmNested<A> editOrNewIbmLike(IBMLoadBalancerParameters item) {
        return this.withNewIbmLike(Optional.ofNullable(this.buildIbm()).orElse(item));
    }

    public OpenStackLoadBalancerParameters buildOpenstack() {
        return this.openstack != null ? this.openstack.build() : null;
    }

    public A withOpenstack(OpenStackLoadBalancerParameters openstack) {
        this._visitables.remove((Object)"openstack");
        if (openstack != null) {
            this.openstack = new OpenStackLoadBalancerParametersBuilder(openstack);
            this._visitables.get((Object)"openstack").add(this.openstack);
        } else {
            this.openstack = null;
            this._visitables.get((Object)"openstack").remove((Object)this.openstack);
        }
        return (A)((Object)this);
    }

    public boolean hasOpenstack() {
        return this.openstack != null;
    }

    public A withNewOpenstack(String floatingIP) {
        return this.withOpenstack(new OpenStackLoadBalancerParameters(floatingIP));
    }

    public OpenstackNested<A> withNewOpenstack() {
        return new OpenstackNested(null);
    }

    public OpenstackNested<A> withNewOpenstackLike(OpenStackLoadBalancerParameters item) {
        return new OpenstackNested(item);
    }

    public OpenstackNested<A> editOpenstack() {
        return this.withNewOpenstackLike(Optional.ofNullable(this.buildOpenstack()).orElse(null));
    }

    public OpenstackNested<A> editOrNewOpenstack() {
        return this.withNewOpenstackLike(Optional.ofNullable(this.buildOpenstack()).orElse(new OpenStackLoadBalancerParametersBuilder().build()));
    }

    public OpenstackNested<A> editOrNewOpenstackLike(OpenStackLoadBalancerParameters item) {
        return this.withNewOpenstackLike(Optional.ofNullable(this.buildOpenstack()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProviderLoadBalancerParametersFluent that = (ProviderLoadBalancerParametersFluent)((Object)o);
        if (!Objects.equals((Object)this.aws, (Object)that.aws)) {
            return false;
        }
        if (!Objects.equals((Object)this.gcp, (Object)that.gcp)) {
            return false;
        }
        if (!Objects.equals((Object)this.ibm, (Object)that.ibm)) {
            return false;
        }
        if (!Objects.equals((Object)this.openstack, (Object)that.openstack)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aws, this.gcp, this.ibm, this.openstack, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(String.valueOf((Object)this.aws) + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(String.valueOf((Object)this.gcp) + ",");
        }
        if (this.ibm != null) {
            sb.append("ibm:");
            sb.append(String.valueOf((Object)this.ibm) + ",");
        }
        if (this.openstack != null) {
            sb.append("openstack:");
            sb.append(String.valueOf((Object)this.openstack) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OpenstackNested<N>
    extends OpenStackLoadBalancerParametersFluent<OpenstackNested<N>>
    implements Nested<N> {
        OpenStackLoadBalancerParametersBuilder builder;

        OpenstackNested(OpenStackLoadBalancerParameters item) {
            this.builder = new OpenStackLoadBalancerParametersBuilder(this, item);
        }

        public N and() {
            return (N)ProviderLoadBalancerParametersFluent.this.withOpenstack(this.builder.build());
        }

        public N endOpenstack() {
            return this.and();
        }
    }

    public class IbmNested<N>
    extends IBMLoadBalancerParametersFluent<IbmNested<N>>
    implements Nested<N> {
        IBMLoadBalancerParametersBuilder builder;

        IbmNested(IBMLoadBalancerParameters item) {
            this.builder = new IBMLoadBalancerParametersBuilder(this, item);
        }

        public N and() {
            return (N)ProviderLoadBalancerParametersFluent.this.withIbm(this.builder.build());
        }

        public N endIbm() {
            return this.and();
        }
    }

    public class GcpNested<N>
    extends GCPLoadBalancerParametersFluent<GcpNested<N>>
    implements Nested<N> {
        GCPLoadBalancerParametersBuilder builder;

        GcpNested(GCPLoadBalancerParameters item) {
            this.builder = new GCPLoadBalancerParametersBuilder(this, item);
        }

        public N and() {
            return (N)ProviderLoadBalancerParametersFluent.this.withGcp(this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AWSLoadBalancerParametersFluent<AwsNested<N>>
    implements Nested<N> {
        AWSLoadBalancerParametersBuilder builder;

        AwsNested(AWSLoadBalancerParameters item) {
            this.builder = new AWSLoadBalancerParametersBuilder(this, item);
        }

        public N and() {
            return (N)ProviderLoadBalancerParametersFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

