/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfig;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.Upstream;
import io.fabric8.openshift.api.model.operator.v1.UpstreamBuilder;
import io.fabric8.openshift.api.model.operator.v1.UpstreamFluent;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolvers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class UpstreamResolversFluent<A extends UpstreamResolversFluent<A>>
extends BaseFluent<A> {
    private String policy;
    private String protocolStrategy;
    private DNSTransportConfigBuilder transportConfig;
    private ArrayList<UpstreamBuilder> upstreams = new ArrayList();
    private Map<String, Object> additionalProperties;

    public UpstreamResolversFluent() {
    }

    public UpstreamResolversFluent(UpstreamResolvers instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(UpstreamResolvers instance) {
        UpstreamResolvers upstreamResolvers = instance = instance != null ? instance : new UpstreamResolvers();
        if (instance != null) {
            this.withPolicy(instance.getPolicy());
            this.withProtocolStrategy(instance.getProtocolStrategy());
            this.withTransportConfig(instance.getTransportConfig());
            this.withUpstreams(instance.getUpstreams());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getPolicy() {
        return this.policy;
    }

    public A withPolicy(String policy) {
        this.policy = policy;
        return (A)((Object)this);
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public String getProtocolStrategy() {
        return this.protocolStrategy;
    }

    public A withProtocolStrategy(String protocolStrategy) {
        this.protocolStrategy = protocolStrategy;
        return (A)((Object)this);
    }

    public boolean hasProtocolStrategy() {
        return this.protocolStrategy != null;
    }

    public DNSTransportConfig buildTransportConfig() {
        return this.transportConfig != null ? this.transportConfig.build() : null;
    }

    public A withTransportConfig(DNSTransportConfig transportConfig) {
        this._visitables.remove((Object)"transportConfig");
        if (transportConfig != null) {
            this.transportConfig = new DNSTransportConfigBuilder(transportConfig);
            this._visitables.get((Object)"transportConfig").add(this.transportConfig);
        } else {
            this.transportConfig = null;
            this._visitables.get((Object)"transportConfig").remove((Object)this.transportConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTransportConfig() {
        return this.transportConfig != null;
    }

    public TransportConfigNested<A> withNewTransportConfig() {
        return new TransportConfigNested(null);
    }

    public TransportConfigNested<A> withNewTransportConfigLike(DNSTransportConfig item) {
        return new TransportConfigNested(item);
    }

    public TransportConfigNested<A> editTransportConfig() {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(null));
    }

    public TransportConfigNested<A> editOrNewTransportConfig() {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(new DNSTransportConfigBuilder().build()));
    }

    public TransportConfigNested<A> editOrNewTransportConfigLike(DNSTransportConfig item) {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(item));
    }

    public A addToUpstreams(int index, Upstream item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        UpstreamBuilder builder = new UpstreamBuilder(item);
        if (index < 0 || index >= this.upstreams.size()) {
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.add(builder);
        } else {
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToUpstreams(int index, Upstream item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        UpstreamBuilder builder = new UpstreamBuilder(item);
        if (index < 0 || index >= this.upstreams.size()) {
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.add(builder);
        } else {
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToUpstreams(Upstream ... items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToUpstreams(Collection<Upstream> items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get((Object)"upstreams").add(builder);
            this.upstreams.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromUpstreams(Upstream ... items) {
        if (this.upstreams == null) {
            return (A)((Object)this);
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get((Object)"upstreams").remove((Object)builder);
            this.upstreams.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUpstreams(Collection<Upstream> items) {
        if (this.upstreams == null) {
            return (A)((Object)this);
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get((Object)"upstreams").remove((Object)builder);
            this.upstreams.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromUpstreams(Predicate<UpstreamBuilder> predicate) {
        if (this.upstreams == null) {
            return (A)((Object)this);
        }
        Iterator<UpstreamBuilder> each = this.upstreams.iterator();
        List visitables = this._visitables.get((Object)"upstreams");
        while (each.hasNext()) {
            UpstreamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Upstream> buildUpstreams() {
        return this.upstreams != null ? UpstreamResolversFluent.build(this.upstreams) : null;
    }

    public Upstream buildUpstream(int index) {
        return this.upstreams.get(index).build();
    }

    public Upstream buildFirstUpstream() {
        return this.upstreams.get(0).build();
    }

    public Upstream buildLastUpstream() {
        return this.upstreams.get(this.upstreams.size() - 1).build();
    }

    public Upstream buildMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        for (UpstreamBuilder item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        for (UpstreamBuilder item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUpstreams(List<Upstream> upstreams) {
        if (this.upstreams != null) {
            this._visitables.get((Object)"upstreams").clear();
        }
        if (upstreams != null) {
            this.upstreams = new ArrayList();
            for (Upstream item : upstreams) {
                this.addToUpstreams(item);
            }
        } else {
            this.upstreams = null;
        }
        return (A)((Object)this);
    }

    public A withUpstreams(Upstream ... upstreams) {
        if (this.upstreams != null) {
            this.upstreams.clear();
            this._visitables.remove((Object)"upstreams");
        }
        if (upstreams != null) {
            for (Upstream item : upstreams) {
                this.addToUpstreams(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUpstreams() {
        return this.upstreams != null && !this.upstreams.isEmpty();
    }

    public A addNewUpstream(String address, Long port, String type) {
        return this.addToUpstreams(new Upstream(address, port, type));
    }

    public UpstreamsNested<A> addNewUpstream() {
        return new UpstreamsNested(-1, null);
    }

    public UpstreamsNested<A> addNewUpstreamLike(Upstream item) {
        return new UpstreamsNested(-1, item);
    }

    public UpstreamsNested<A> setNewUpstreamLike(int index, Upstream item) {
        return new UpstreamsNested(index, item);
    }

    public UpstreamsNested<A> editUpstream(int index) {
        if (this.upstreams.size() <= index) {
            throw new RuntimeException("Can't edit upstreams. Index exceeds size.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    public UpstreamsNested<A> editFirstUpstream() {
        if (this.upstreams.size() == 0) {
            throw new RuntimeException("Can't edit first upstreams. The list is empty.");
        }
        return this.setNewUpstreamLike(0, this.buildUpstream(0));
    }

    public UpstreamsNested<A> editLastUpstream() {
        int index = this.upstreams.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last upstreams. The list is empty.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    public UpstreamsNested<A> editMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.upstreams.size(); ++i) {
            if (!predicate.test(this.upstreams.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching upstreams. No match found.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpstreamResolversFluent that = (UpstreamResolversFluent)((Object)o);
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.protocolStrategy, that.protocolStrategy)) {
            return false;
        }
        if (!Objects.equals((Object)this.transportConfig, (Object)that.transportConfig)) {
            return false;
        }
        if (!Objects.equals(this.upstreams, that.upstreams)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.protocolStrategy, this.transportConfig, this.upstreams, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.protocolStrategy != null) {
            sb.append("protocolStrategy:");
            sb.append(this.protocolStrategy + ",");
        }
        if (this.transportConfig != null) {
            sb.append("transportConfig:");
            sb.append(String.valueOf((Object)this.transportConfig) + ",");
        }
        if (this.upstreams != null && !this.upstreams.isEmpty()) {
            sb.append("upstreams:");
            sb.append(String.valueOf(this.upstreams) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpstreamsNested<N>
    extends UpstreamFluent<UpstreamsNested<N>>
    implements Nested<N> {
        UpstreamBuilder builder;
        int index;

        UpstreamsNested(int index, Upstream item) {
            this.index = index;
            this.builder = new UpstreamBuilder(this, item);
        }

        public N and() {
            return (N)UpstreamResolversFluent.this.setToUpstreams(this.index, this.builder.build());
        }

        public N endUpstream() {
            return this.and();
        }
    }

    public class TransportConfigNested<N>
    extends DNSTransportConfigFluent<TransportConfigNested<N>>
    implements Nested<N> {
        DNSTransportConfigBuilder builder;

        TransportConfigNested(DNSTransportConfig item) {
            this.builder = new DNSTransportConfigBuilder(this, item);
        }

        public N and() {
            return (N)UpstreamResolversFluent.this.withTransportConfig(this.builder.build());
        }

        public N endTransportConfig() {
            return this.and();
        }
    }
}

