/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupStatus;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OperatorGroupStatusFluentImpl<A extends OperatorGroupStatusFluent<A>>
extends BaseFluent<A>
implements OperatorGroupStatusFluent<A> {
    private String lastUpdated;
    private List<String> namespaces = new ArrayList<String>();
    private ObjectReferenceBuilder serviceAccountRef;

    public OperatorGroupStatusFluentImpl() {
    }

    public OperatorGroupStatusFluentImpl(OperatorGroupStatus instance) {
        this.withLastUpdated(instance.getLastUpdated());
        this.withNamespaces(instance.getNamespaces());
        this.withServiceAccountRef(instance.getServiceAccountRef());
    }

    @Override
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)this;
    }

    @Override
    public Boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    @Override
    public A withNewLastUpdated(String arg1) {
        return this.withLastUpdated(new String(arg1));
    }

    @Override
    public A withNewLastUpdated(StringBuilder arg1) {
        return this.withLastUpdated(new String(arg1));
    }

    @Override
    public A withNewLastUpdated(StringBuffer arg1) {
        return this.withLastUpdated(new String(arg1));
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get((Object)"namespaces").removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuilder arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuffer arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getServiceAccountRef() {
        return this.serviceAccountRef != null ? this.serviceAccountRef.build() : null;
    }

    @Override
    public ObjectReference buildServiceAccountRef() {
        return this.serviceAccountRef != null ? this.serviceAccountRef.build() : null;
    }

    @Override
    public A withServiceAccountRef(ObjectReference serviceAccountRef) {
        this._visitables.get((Object)"serviceAccountRef").remove(this.serviceAccountRef);
        if (serviceAccountRef != null) {
            this.serviceAccountRef = new ObjectReferenceBuilder(serviceAccountRef);
            this._visitables.get((Object)"serviceAccountRef").add(this.serviceAccountRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountRef() {
        return this.serviceAccountRef != null;
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRef() {
        return new ServiceAccountRefNestedImpl();
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRefLike(ObjectReference item) {
        return new ServiceAccountRefNestedImpl(item);
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editServiceAccountRef() {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef());
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRef() {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef() != null ? this.getServiceAccountRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRefLike(ObjectReference item) {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef() != null ? this.getServiceAccountRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorGroupStatusFluentImpl that = (OperatorGroupStatusFluentImpl)o;
        if (this.lastUpdated != null ? !this.lastUpdated.equals(that.lastUpdated) : that.lastUpdated != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.serviceAccountRef != null ? !this.serviceAccountRef.equals((Object)that.serviceAccountRef) : that.serviceAccountRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdated, this.namespaces, this.serviceAccountRef, super.hashCode());
    }

    public class ServiceAccountRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<OperatorGroupStatusFluent.ServiceAccountRefNested<N>>
    implements OperatorGroupStatusFluent.ServiceAccountRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ServiceAccountRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        ServiceAccountRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)OperatorGroupStatusFluentImpl.this.withServiceAccountRef(this.builder.build());
        }

        @Override
        public N endServiceAccountRef() {
            return this.and();
        }
    }
}

