package io.fabric8.openshift.api.model.operatorhub.manifests;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PackageManifestFluentImpl<A extends PackageManifestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PackageManifestFluent<A> {

    private List<PackageChannelBuilder> channels =  new ArrayList<PackageChannelBuilder>();
    private String defaultChannel;
    private String packageName;

    public PackageManifestFluentImpl() { 
    }


    public PackageManifestFluentImpl(PackageManifest instance) { 
        this.withChannels(instance.getChannels()); 
        this.withDefaultChannel(instance.getDefaultChannel()); 
        this.withPackageName(instance.getPackageName()); 
    }


    public A addToChannels(int index,PackageChannel item) {
        if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
        PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").add(index >= 0 ? index : _visitables.get("channels").size(), builder);this.channels.add(index >= 0 ? index : channels.size(), builder); return (A)this;
    }

    public A setToChannels(int index,PackageChannel item) {
        if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        if (index < 0 || index >= _visitables.get("channels").size()) { _visitables.get("channels").add(builder); } else { _visitables.get("channels").set(index, builder);}
        if (index < 0 || index >= channels.size()) { channels.add(builder); } else { channels.set(index, builder);}
         return (A)this;
    }

    public A addToChannels(PackageChannel... items) {
        if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
        for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
    }

    public A addAllToChannels(Collection<PackageChannel> items) {
        if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
        for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
    }

    public A removeFromChannels(PackageChannel... items) {
        for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").remove(builder);if (this.channels != null) {this.channels.remove(builder);}} return (A)this;
    }

    public A removeAllFromChannels(Collection<PackageChannel> items) {
        for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").remove(builder);if (this.channels != null) {this.channels.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromChannels(io.fabric8.kubernetes.api.builder.Predicate<PackageChannelBuilder> predicate) {
        if (channels == null) return (A) this;
        final Iterator<PackageChannelBuilder> each = channels.iterator();
        final List visitables = _visitables.get("channels");
        while (each.hasNext()) {
          PackageChannelBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildChannels instead.
 * @return The buildable object.
 */
@Deprecated public List<PackageChannel> getChannels() {
        return build(channels);
    }

    public List<PackageChannel> buildChannels() {
        return build(channels);
    }

    public PackageChannel buildChannel(int index) {
        return this.channels.get(index).build();
    }

    public PackageChannel buildFirstChannel() {
        return this.channels.get(0).build();
    }

    public PackageChannel buildLastChannel() {
        return this.channels.get(channels.size() - 1).build();
    }

    public PackageChannel buildMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item: channels) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item: channels) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withChannels(List<PackageChannel> channels) {
        if (this.channels != null) { _visitables.get("channels").removeAll(this.channels);}
        if (channels != null) {this.channels = new ArrayList<PackageChannelBuilder>(); for (PackageChannel item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
    }

    public A withChannels(PackageChannel... channels) {
        if (this.channels != null) {this.channels.clear();}
        if (channels != null) {for (PackageChannel item :channels){ this.addToChannels(item);}} return (A) this;
    }

    public Boolean hasChannels() {
        return channels != null && !channels.isEmpty();
    }

    public A addNewChannel(String currentCSV,String name) {
        return (A)addToChannels(new PackageChannel(currentCSV, name));
    }

    public PackageManifestFluent.ChannelsNested<A> addNewChannel() {
        return new ChannelsNestedImpl();
    }

    public PackageManifestFluent.ChannelsNested<A> addNewChannelLike(PackageChannel item) {
        return new ChannelsNestedImpl(-1, item);
    }

    public PackageManifestFluent.ChannelsNested<A> setNewChannelLike(int index,PackageChannel item) {
        return new ChannelsNestedImpl(index, item);
    }

    public PackageManifestFluent.ChannelsNested<A> editChannel(int index) {
        if (channels.size() <= index) throw new RuntimeException("Can't edit channels. Index exceeds size.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public PackageManifestFluent.ChannelsNested<A> editFirstChannel() {
        if (channels.size() == 0) throw new RuntimeException("Can't edit first channels. The list is empty.");
        return setNewChannelLike(0, buildChannel(0));
    }

    public PackageManifestFluent.ChannelsNested<A> editLastChannel() {
        int index = channels.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last channels. The list is empty.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public PackageManifestFluent.ChannelsNested<A> editMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<PackageChannelBuilder> predicate) {
        int index = -1;
        for (int i=0;i<channels.size();i++) { 
        if (predicate.apply(channels.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching channels. No match found.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public A withDefaultChannel(String defaultChannel) {
        this.defaultChannel=defaultChannel; return (A) this;
    }

    public Boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    public A withNewDefaultChannel(String arg1) {
        return (A)withDefaultChannel(new String(arg1));
    }

    public A withNewDefaultChannel(StringBuilder arg1) {
        return (A)withDefaultChannel(new String(arg1));
    }

    public A withNewDefaultChannel(StringBuffer arg1) {
        return (A)withDefaultChannel(new String(arg1));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public A withPackageName(String packageName) {
        this.packageName=packageName; return (A) this;
    }

    public Boolean hasPackageName() {
        return this.packageName != null;
    }

    public A withNewPackageName(String arg1) {
        return (A)withPackageName(new String(arg1));
    }

    public A withNewPackageName(StringBuilder arg1) {
        return (A)withPackageName(new String(arg1));
    }

    public A withNewPackageName(StringBuffer arg1) {
        return (A)withPackageName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PackageManifestFluentImpl that = (PackageManifestFluentImpl) o;
        if (channels != null ? !channels.equals(that.channels) :that.channels != null) return false;
        if (defaultChannel != null ? !defaultChannel.equals(that.defaultChannel) :that.defaultChannel != null) return false;
        if (packageName != null ? !packageName.equals(that.packageName) :that.packageName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channels,  defaultChannel,  packageName,  super.hashCode());
    }

    public class ChannelsNestedImpl<N> extends PackageChannelFluentImpl<PackageManifestFluent.ChannelsNested<N>> implements PackageManifestFluent.ChannelsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PackageChannelBuilder builder;
        private final int index;

        ChannelsNestedImpl(int index,PackageChannel item) {
            this.index = index;
            this.builder = new PackageChannelBuilder(this, item);
        }

        ChannelsNestedImpl() {
            this.index = -1;
            this.builder = new PackageChannelBuilder(this);
        }

        public N and() {
             return (N) PackageManifestFluentImpl.this.setToChannels(index,builder.build());
        }

        public N endChannel() {
             return and();
        }
    }


}
