package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CatalogSourceListBuilder extends CatalogSourceListFluentImpl<CatalogSourceListBuilder> implements VisitableBuilder<CatalogSourceList,CatalogSourceListBuilder> {

    CatalogSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public CatalogSourceListBuilder() { 
        this(true);
    }


    public CatalogSourceListBuilder(Boolean validationEnabled) { 
        this(new CatalogSourceList(), validationEnabled);
    }


    public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent) { 
        this(fluent, true);
    }


    public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CatalogSourceList(), validationEnabled);
    }


    public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,CatalogSourceList instance) { 
        this(fluent, instance, true);
    }


    public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,CatalogSourceList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public CatalogSourceListBuilder(CatalogSourceList instance) { 
        this(instance,true);
    }


    public CatalogSourceListBuilder(CatalogSourceList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public CatalogSourceList build() {
        CatalogSourceList buildable = new CatalogSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CatalogSourceListBuilder that = (CatalogSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
