package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterServiceVersionSpecBuilder extends ClusterServiceVersionSpecFluentImpl<ClusterServiceVersionSpecBuilder> implements VisitableBuilder<ClusterServiceVersionSpec,ClusterServiceVersionSpecBuilder> {

    ClusterServiceVersionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceVersionSpecBuilder() { 
        this(true);
    }


    public ClusterServiceVersionSpecBuilder(Boolean validationEnabled) { 
        this(new ClusterServiceVersionSpec(), validationEnabled);
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterServiceVersionSpec(), validationEnabled);
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpecFluent<?> fluent,ClusterServiceVersionSpec instance) { 
        this(fluent, instance, true);
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpecFluent<?> fluent,ClusterServiceVersionSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withApiservicedefinitions(instance.getApiservicedefinitions()); 
        fluent.withCustomresourcedefinitions(instance.getCustomresourcedefinitions()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withDisplayName(instance.getDisplayName()); 
        fluent.withIcon(instance.getIcon()); 
        fluent.withInstall(instance.getInstall()); 
        fluent.withInstallModes(instance.getInstallModes()); 
        fluent.withKeywords(instance.getKeywords()); 
        fluent.withLabels(instance.getLabels()); 
        fluent.withLinks(instance.getLinks()); 
        fluent.withMaintainers(instance.getMaintainers()); 
        fluent.withMaturity(instance.getMaturity()); 
        fluent.withMinKubeVersion(instance.getMinKubeVersion()); 
        fluent.withNativeAPIs(instance.getNativeAPIs()); 
        fluent.withProvider(instance.getProvider()); 
        fluent.withReplaces(instance.getReplaces()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withWebhookdefinitions(instance.getWebhookdefinitions()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpec instance) { 
        this(instance,true);
    }


    public ClusterServiceVersionSpecBuilder(ClusterServiceVersionSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withApiservicedefinitions(instance.getApiservicedefinitions()); 
        this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions()); 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withIcon(instance.getIcon()); 
        this.withInstall(instance.getInstall()); 
        this.withInstallModes(instance.getInstallModes()); 
        this.withKeywords(instance.getKeywords()); 
        this.withLabels(instance.getLabels()); 
        this.withLinks(instance.getLinks()); 
        this.withMaintainers(instance.getMaintainers()); 
        this.withMaturity(instance.getMaturity()); 
        this.withMinKubeVersion(instance.getMinKubeVersion()); 
        this.withNativeAPIs(instance.getNativeAPIs()); 
        this.withProvider(instance.getProvider()); 
        this.withReplaces(instance.getReplaces()); 
        this.withSelector(instance.getSelector()); 
        this.withVersion(instance.getVersion()); 
        this.withWebhookdefinitions(instance.getWebhookdefinitions()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterServiceVersionSpec build() {
        ClusterServiceVersionSpec buildable = new ClusterServiceVersionSpec(fluent.getAnnotations(),fluent.getApiservicedefinitions(),fluent.getCustomresourcedefinitions(),fluent.getDescription(),fluent.getDisplayName(),fluent.getIcon(),fluent.getInstall(),fluent.getInstallModes(),fluent.getKeywords(),fluent.getLabels(),fluent.getLinks(),fluent.getMaintainers(),fluent.getMaturity(),fluent.getMinKubeVersion(),fluent.getNativeAPIs(),fluent.getProvider(),fluent.getReplaces(),fluent.getSelector(),fluent.getVersion(),fluent.getWebhookdefinitions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterServiceVersionSpecBuilder that = (ClusterServiceVersionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
