package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterServiceVersionConditionBuilder extends ClusterServiceVersionConditionFluentImpl<ClusterServiceVersionConditionBuilder> implements VisitableBuilder<ClusterServiceVersionCondition,ClusterServiceVersionConditionBuilder> {

    ClusterServiceVersionConditionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceVersionConditionBuilder() { 
        this(true);
    }


    public ClusterServiceVersionConditionBuilder(Boolean validationEnabled) { 
        this(new ClusterServiceVersionCondition(), validationEnabled);
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterServiceVersionCondition(), validationEnabled);
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,ClusterServiceVersionCondition instance) { 
        this(fluent, instance, true);
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,ClusterServiceVersionCondition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionCondition instance) { 
        this(instance,true);
    }


    public ClusterServiceVersionConditionBuilder(ClusterServiceVersionCondition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterServiceVersionCondition build() {
        ClusterServiceVersionCondition buildable = new ClusterServiceVersionCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterServiceVersionConditionBuilder that = (ClusterServiceVersionConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
