package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface InstallPlanListFluent<A extends InstallPlanListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,InstallPlan item);
    public A setToItems(int index,InstallPlan item);
    public A addToItems(InstallPlan... items);
    public A addAllToItems(Collection<InstallPlan> items);
    public A removeFromItems(InstallPlan... items);
    public A removeAllFromItems(Collection<InstallPlan> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<InstallPlan> getItems();
    public List<InstallPlan> buildItems();
    public InstallPlan buildItem(int index);
    public InstallPlan buildFirstItem();
    public InstallPlan buildLastItem();
    public InstallPlan buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanBuilder> predicate);
    public A withItems(List<InstallPlan> items);
    public A withItems(InstallPlan... items);
    public Boolean hasItems();
    public InstallPlanListFluent.ItemsNested<A> addNewItem();
    public InstallPlanListFluent.ItemsNested<A> addNewItemLike(InstallPlan item);
    public InstallPlanListFluent.ItemsNested<A> setNewItemLike(int index,InstallPlan item);
    public InstallPlanListFluent.ItemsNested<A> editItem(int index);
    public InstallPlanListFluent.ItemsNested<A> editFirstItem();
    public InstallPlanListFluent.ItemsNested<A> editLastItem();
    public InstallPlanListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<InstallPlanBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InstallPlanFluent<InstallPlanListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
